/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.wheelview;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.List;
import sunmi.sunmiui.wheelview.BaseWheelAdapter;
import sunmi.sunmiui.wheelview.IWheelView;

public class WheelListView
extends ListView
implements IWheelView {
    public static final String TAG = "WheelListView";
    public static final int WHEEL_SMOOTH_SCROLL_DURATION = 50;
    public static final int WHEEL_SCROLL_DELAY_DURATION = 300;
    public static final int WHEEL_SCROLL_HANDLER_WHAT = 256;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 256) {
                WheelListView.this.mWheelAdapter.notifyDataSetChanged();
                if (WheelListView.this.mOnWheelItemSelectedListener != null) {
                    WheelListView.this.mOnWheelItemSelectedListener.onItemSelected(WheelListView.this.getCurrentPosition());
                }
            }
        }
    };
    private boolean mLoop = true;
    private int mItemH = 0;
    private OnWheelItemSelectedListener mOnWheelItemSelectedListener;
    private int mCurrentPositon;
    private BaseWheelAdapter mWheelAdapter;
    private int mWheelSize = 5;
    private AbsListView.OnScrollListener mCustomerScrollListener;
    private AbsListView.OnScrollListener mOnScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            View itemView;
            if (WheelListView.this.mCustomerScrollListener != null) {
                WheelListView.this.mCustomerScrollListener.onScrollStateChanged(view, scrollState);
            }
            if (scrollState == 0 && (itemView = WheelListView.this.getChildAt(0)) != null) {
                float deltaY = itemView.getY();
                if (deltaY == 0.0f || WheelListView.this.mItemH == 0) {
                    return;
                }
                if (Math.abs(deltaY) < (float)(WheelListView.this.mItemH / 2)) {
                    int d = WheelListView.this.getSmoothDistance(deltaY);
                    WheelListView.this.smoothScrollBy(d, 50);
                } else {
                    int d = WheelListView.this.getSmoothDistance((float)WheelListView.this.mItemH + deltaY);
                    WheelListView.this.smoothScrollBy(d, 50);
                }
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (WheelListView.this.mCustomerScrollListener != null) {
                WheelListView.this.mCustomerScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            if (visibleItemCount != 0) {
                WheelListView.this.refreshCurrentPosition();
            }
        }
    };

    public WheelListView(Context context) {
        super(context);
        this.init();
    }

    public WheelListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WheelListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public WheelListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setScrollingCacheEnabled(false);
        this.setCacheColorHint(0);
        this.setFadingEdgeLength(0);
        this.setOverScrollMode(2);
        this.setDividerHeight(0);
        super.setOnScrollListener(this.mOnScrollListener);
        this.addOnGlobalLayoutListener();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        super.setOnScrollListener(this.mOnScrollListener);
        this.mCustomerScrollListener = l;
    }

    private void refreshCurrentPosition() {
        if (this.getChildAt(0) == null || this.mItemH == 0) {
            return;
        }
        int firstPosition = this.getFirstVisiblePosition();
        if (this.mLoop && firstPosition == 0) {
            return;
        }
        int position = 0;
        position = Math.abs(this.getChildAt(0).getY()) <= (float)(this.mItemH / 2) ? firstPosition : firstPosition + 1;
        if (this.mLoop) {
            position = (position + this.mWheelSize / 2) % this.mWheelAdapter.getWheelCount();
        }
        if (position == this.mCurrentPositon) {
            return;
        }
        this.mCurrentPositon = position;
        this.mWheelAdapter.setCurrentPosition(position);
        this.mHandler.removeMessages(256);
        this.mHandler.sendEmptyMessageDelayed(256, 300L);
    }

    private void addOnGlobalLayoutListener() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    WheelListView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    WheelListView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                if (WheelListView.this.getChildCount() > 0 && WheelListView.this.mItemH == 0) {
                    WheelListView.this.mItemH = WheelListView.this.getChildAt(0).getHeight();
                    if (WheelListView.this.mItemH != 0) {
                        ViewGroup.LayoutParams params = WheelListView.this.getLayoutParams();
                        params.height = WheelListView.this.mItemH * WheelListView.this.mWheelSize;
                    } else {
                        throw new RuntimeException("wheel item is error.");
                    }
                }
            }
        });
    }

    private int getSmoothDistance(float scrollDistance) {
        if (Math.abs(scrollDistance) <= 2.0f) {
            return (int)scrollDistance;
        }
        if (Math.abs(scrollDistance) < 12.0f) {
            return scrollDistance > 0.0f ? 2 : -2;
        }
        return (int)(scrollDistance / 6.0f);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.dispatchTouchEvent(ev);
    }

    public void setOnWheelItemSelectedListener(OnWheelItemSelectedListener l) {
        this.mOnWheelItemSelectedListener = l;
    }

    @Override
    public void setLoop(boolean loop) {
        this.mLoop = loop;
    }

    public void setAdapter(ListAdapter adapter) {
        if (adapter == null || !(adapter instanceof BaseWheelAdapter)) {
            throw new RuntimeException("please invoke setWheelAdapter method.");
        }
        this.setWheelAdapter((BaseWheelAdapter)adapter);
    }

    @Override
    public void setWheelAdapter(BaseWheelAdapter adapter) {
        super.setAdapter((ListAdapter)adapter);
        this.mWheelAdapter = adapter;
        this.mWheelAdapter.setLoop(this.mLoop);
    }

    @Override
    public void setWheelSize(int wheelSize) {
        if ((wheelSize & 1) == 0) {
            throw new RuntimeException("wheel size must be an odd number.");
        }
        this.mWheelSize = wheelSize;
    }

    public int getCurrentPosition() {
        return this.mCurrentPositon;
    }

    public void setSelection(final int selection) {
        this.setVisibility(4);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                WheelListView.super.setSelection(WheelListView.this.getRealPosition(selection));
                WheelListView.this.refreshCurrentPosition();
                WheelListView.this.setVisibility(0);
            }
        }, 500L);
    }

    private int getRealPosition(int positon) {
        List data = this.mWheelAdapter.getData();
        if (this.mWheelAdapter.getData().isEmpty()) {
            return 0;
        }
        if (this.mLoop) {
            int d = 0x3FFFFFFF / data.size();
            return positon + d * data.size() - this.getChildCount() / 2;
        }
        return positon;
    }

    public static interface OnWheelItemSelectedListener {
        public void onItemSelected(int var1);
    }
}

