/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.wheelview;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.Collection;
import java.util.List;

public abstract class BaseWheelAdapter<T>
extends BaseAdapter {
    private static final String TAG = "BaseWheelAdapter";
    protected List<T> mList = null;
    protected boolean mLoop = true;
    protected int mCurrentPositon = -1;

    protected abstract View bindView(int var1, View var2, ViewGroup var3);

    public final void setCurrentPosition(int position) {
        this.mCurrentPositon = position;
    }

    public final int getCount() {
        if (this.mLoop) {
            return Integer.MAX_VALUE;
        }
        return !BaseWheelAdapter.isEmpty(this.mList) ? this.mList.size() : 0;
    }

    public final long getItemId(int position) {
        return !BaseWheelAdapter.isEmpty(this.mList) ? (long)(position % this.mList.size()) : (long)position;
    }

    public final T getItem(int position) {
        return !BaseWheelAdapter.isEmpty(this.mList) ? (T)this.mList.get(position % this.mList.size()) : null;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        Log.d((String)TAG, (String)("getView position:" + position));
        if (this.mLoop) {
            position %= this.mList.size();
        }
        View view = position == -1 ? this.bindView(0, convertView, parent) : this.bindView(position, convertView, parent);
        if (!this.mLoop) {
            if (position == -1) {
                view.setVisibility(4);
            } else {
                view.setVisibility(0);
            }
        }
        return view;
    }

    public final BaseWheelAdapter setLoop(boolean loop) {
        if (loop != this.mLoop) {
            this.mLoop = loop;
            super.notifyDataSetChanged();
        }
        return this;
    }

    public final BaseWheelAdapter setData(List<T> list) {
        this.mList = list;
        super.notifyDataSetChanged();
        return this;
    }

    public final List<T> getData() {
        return this.mList;
    }

    public static <V> boolean isEmpty(Collection<V> c) {
        return c == null || c.size() == 0;
    }

    public int getWheelCount() {
        return !BaseWheelAdapter.isEmpty(this.mList) ? this.mList.size() : 0;
    }
}

