/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.flexible;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.ScrollView;
import sunmi.sunmiui.flexible.Flexible;
import sunmi.sunmiui.flexible.FlexibleEffect;
import sunmi.sunmiui.utils.LogUtil;

public class FlexibleScrollView
extends ScrollView
implements Flexible {
    private static final String TAG = "FlexibleScrollView";
    private static final int INVALID_POINTER = -1;
    private FlexibleEffect mFlexibleEffect;
    private int mLastMotionY;
    private int mActivePointerId = -1;
    private boolean mIsBeingDragged = false;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;
    private int mMaximumVelocity;
    private float currentVelocity;

    public FlexibleScrollView(Context context) {
        super(context);
        this.init();
    }

    public FlexibleScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FlexibleScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public FlexibleScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setOverScrollMode(2);
        this.mFlexibleEffect = new FlexibleEffect((View)this);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mIsBeingDragged = false;
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) break;
                int y = (int)ev.getY(activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y;
                this.mFlexibleEffect.onPull((float)deltaY / (float)this.getHeight());
                if (this.mFlexibleEffect.isFinished()) break;
                return true;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                if (this.mFlexibleEffect != null && this.mFlexibleEffect.isPulling()) {
                    this.mFlexibleEffect.onAbsorb(-1L);
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                this.currentVelocity = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                LogUtil.d(TAG, "currentVelocity:" + this.mVelocityTracker.getYVelocity(this.mActivePointerId));
                this.recycleVelocityTracker();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public boolean isTop() {
        return this.getScrollY() == 0;
    }

    @Override
    public boolean isBottom() {
        View childView = this.getChildAt(0);
        boolean isBottom = false;
        if (childView != null) {
            isBottom = childView.getMeasuredHeight() <= this.getScrollY() + this.getHeight();
        }
        return isBottom;
    }

    @Override
    public void setResistance(float resistance) {
        this.mFlexibleEffect.setResistance(resistance);
    }

    @Override
    public void setTopFlexible(boolean topFlexible) {
        this.mFlexibleEffect.setTopFlexible(topFlexible);
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
        if (this.isBottom() || this.isTop()) {
            this.mFlexibleEffect.onFling(this.currentVelocity);
            this.currentVelocity = 0.0f;
        }
    }
}

