/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.flexible;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.ListView;
import sunmi.sunmiui.flexible.Flexible;
import sunmi.sunmiui.flexible.FlexibleEffect;
import sunmi.sunmiui.utils.LogUtil;

public class FlexibleListView
extends ListView
implements Flexible {
    private static final String TAG = "FlexibleListView";
    private static final int INVALID_POINTER = -1;
    private ScrollListener scrollListener;
    private AbsListView.OnScrollListener customerScrollListener;
    private int mLastMotionY;
    private int mActivePointerId = -1;
    private boolean mIsBeingDragged = false;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;
    private int mMaximumVelocity;
    private float currentVelocity;
    private FlexibleEffect mFlexibleEffect;

    @TargetApi(value=21)
    public FlexibleListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public FlexibleListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public FlexibleListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FlexibleListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setOverScrollMode(2);
        this.scrollListener = new ScrollListener();
        this.mFlexibleEffect = new FlexibleEffect((View)this);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        super.setOnScrollListener((AbsListView.OnScrollListener)this.scrollListener);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.customerScrollListener = l;
        super.setOnScrollListener((AbsListView.OnScrollListener)this.scrollListener);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        Log.d((String)"onScrollChanged", (String)("onScrollChanged l:" + l + " t:" + t + " oldl:" + oldl + " oldt:" + oldt));
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void setOverScrollMode(int mode) {
        super.setOverScrollMode(2);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mIsBeingDragged = false;
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) break;
                int y = (int)ev.getY(activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y;
                this.mFlexibleEffect.onPull((float)deltaY / (float)this.getHeight());
                if (this.mFlexibleEffect.isFinished()) break;
                return true;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                if (this.mFlexibleEffect != null && this.mFlexibleEffect.isPulling()) {
                    this.mFlexibleEffect.onAbsorb(-1L);
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                this.currentVelocity = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                LogUtil.d(TAG, "currentVelocity:" + this.mVelocityTracker.getYVelocity(this.mActivePointerId));
                this.recycleVelocityTracker();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    @Override
    public boolean isTop() {
        View firstVisibleItemView;
        int firstVisibleItem = this.getFirstVisiblePosition();
        if (firstVisibleItem == 0 && (firstVisibleItemView = this.getChildAt(0)) != null && firstVisibleItemView.getTop() == this.getPaddingTop()) {
            Log.d((String)TAG, (String)"##### \u6eda\u52a8\u5230\u9876\u90e8 ######");
            return true;
        }
        return false;
    }

    @Override
    public boolean isBottom() {
        View lastVisibleItemView;
        int totalItemCount;
        int visibleItemCount;
        int firstVisibleItem = this.getFirstVisiblePosition();
        if (firstVisibleItem + (visibleItemCount = this.getChildCount()) == (totalItemCount = this.getCount()) && (lastVisibleItemView = this.getChildAt(this.getChildCount() - 1)) != null && lastVisibleItemView.getBottom() == this.getHeight() - this.getPaddingBottom()) {
            Log.d((String)TAG, (String)"##### \u6eda\u52a8\u5230\u5e95\u90e8 ######");
            return true;
        }
        return false;
    }

    @Override
    public void setResistance(float resistance) {
        this.mFlexibleEffect.setResistance(resistance);
    }

    @Override
    public void setTopFlexible(boolean topFlexible) {
        this.mFlexibleEffect.setTopFlexible(topFlexible);
    }

    class ScrollListener
    implements AbsListView.OnScrollListener {
        ScrollListener() {
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (FlexibleListView.this.customerScrollListener != null) {
                FlexibleListView.this.customerScrollListener.onScrollStateChanged(view, scrollState);
            }
            if (scrollState == 0) {
                Log.d((String)FlexibleListView.TAG, (String)"scrollState == OnScrollListener.SCROLL_STATE_IDLE");
                if (FlexibleListView.this.isBottom() || FlexibleListView.this.isTop()) {
                    FlexibleListView.this.mFlexibleEffect.onFling(FlexibleListView.this.currentVelocity);
                    FlexibleListView.this.currentVelocity = 0.0f;
                }
            } else if (scrollState == 2 || scrollState == 1) {
                // empty if block
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (FlexibleListView.this.customerScrollListener != null) {
                FlexibleListView.this.customerScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }
}

