/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.edit;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import sunmi.sunmiui.R;

public abstract class BaseEdit
extends FrameLayout {
    protected EditText editText;
    protected Resources resources;

    public BaseEdit(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public BaseEdit(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BaseEdit(Context context) {
        super(context);
        this.init();
    }

    @TargetApi(value=21)
    void init() {
        this.resources = this.getResources();
        View view = this.createView();
        this.editText = (EditText)view.findViewById(R.id.edit);
    }

    protected abstract View createView();

    public void setHintText(String hintText) {
        this.editText.setHint((CharSequence)hintText);
    }

    public void setTextColor(int color2) {
        this.editText.setTextColor(color2);
    }

    public void setHintTextColor(int color2) {
        this.editText.setHintTextColor(color2);
    }

    public void setTextSize(float size) {
        this.editText.setTextSize(size);
    }

    @TargetApi(value=16)
    public void setBackground(Drawable drawable2) {
        this.editText.setBackground(drawable2);
    }

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.editText.getLayoutParams();
        layoutParams.width = width;
        this.editText.setLayoutParams(layoutParams);
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.editText.getLayoutParams();
        layoutParams.height = height;
        this.editText.setLayoutParams(layoutParams);
    }

    public String getText() {
        return this.editText.getText().toString();
    }
}

