/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.banner;

import android.content.Context;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;
import sunmi.sunmiui.banner.Banner;
import sunmi.sunmiui.banner.BannerLayout;
import sunmi.sunmiui.banner.State;
import sunmi.sunmiui.utils.LogUtil;

class Looper {
    private static final String TAG = "Looper";
    private static final String TAG1 = "Looper1";
    private static final String TAG2 = "Looper2";
    private Context context;
    BannerLayout bannerLayout;
    Banner origin;
    Banner exitHead;
    Banner enterHead;
    Banner runningMan;
    Object animCancelLock = new Object();
    boolean animCancel = false;
    Object vaneLock = new Object();
    Vane vane;
    List<Banner> bannerList = new ArrayList<Banner>();
    Runnable reStart = new Runnable(){

        @Override
        public void run() {
            Looper.this.start();
        }
    };

    public Looper(BannerLayout layout) {
        this.bannerLayout = layout;
        this.context = layout.getContext();
    }

    private Looper() {
    }

    public void clear() {
        this.enterHead = null;
        this.exitHead = null;
        this.bannerList.clear();
        this.runningMan = null;
        this.setVane(Vane.LEFT);
    }

    public void add(Banner banner) {
        this.bannerList.add(banner);
        int indexOf = this.bannerList.indexOf(banner);
        int size = this.bannerLayout.getSize();
        banner.looper = this;
        if (indexOf == 1) {
            this.enterHead = banner;
        }
        if (indexOf == size - 1) {
            this.exitHead = banner;
        }
        if (indexOf == 0) {
            this.origin = banner;
            return;
        }
        if (indexOf - 1 >= 0) {
            banner.setState(State.Entered);
            if (indexOf - 1 == 0) {
                return;
            }
            Banner preBanner = this.bannerList.get(indexOf - 1);
            preBanner.nextEnter = banner;
            banner.nextExit = preBanner;
        }
    }

    public void start() {
        this.setAnimCancel(false);
        if (this.runningMan == null) {
            this.exitHead.exit(Banner.DELAY, true);
            this.setVane(Vane.LEFT);
            return;
        }
        Banner banner = this.runningMan;
        switch (this.getVane()) {
            case LEFT: {
                if (banner.isEnterHead() && banner.isExited()) {
                    this.setVane(Vane.RIGHT);
                    this.enterHead.enter(0, true);
                    break;
                }
                banner.exit(0, true);
                break;
            }
            case RIGHT: {
                if (banner.isExitHead() && banner.isEntered()) {
                    this.setVane(Vane.LEFT);
                    this.exitHead.exit(0, true);
                    break;
                }
                banner.enter(0, true);
                break;
            }
        }
    }

    public void stop() {
        this.setAnimCancel(true);
        if (this.runningMan != null) {
            this.runningMan.cancelAnim();
            LogUtil.d(TAG, "stop() position:" + this.runningMan.position + " state:" + (Object)((Object)this.runningMan.getState()));
        }
    }

    public synchronized void changeRunningManAuto(Banner banner, State state) {
        this.runningMan = banner;
        LogUtil.d(TAG, "changeRunningManAuto: runningMan position" + this.runningMan.position + " state:" + (Object)((Object)state));
        switch (state) {
            case Exited: {
                this.bannerLayout.notifyOnPageShow();
                if (banner.isEnterHead()) {
                    this.setVane(Vane.RIGHT);
                    if (this.enterHead == null) break;
                    this.enterHead.enter(Banner.DELAY, true);
                    break;
                }
                banner.nextExit.exit(Banner.DELAY, true);
                break;
            }
            case Entered: {
                this.bannerLayout.notifyOnPageShow();
                if (banner.isExitHead()) {
                    this.setVane(Vane.LEFT);
                    this.exitHead.exit(Banner.DELAY, true);
                    break;
                }
                banner.nextEnter.enter(Banner.DELAY, true);
                break;
            }
        }
    }

    public Banner get(int position) {
        return this.bannerList.get(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVane(Vane vane) {
        Object object = this.vaneLock;
        synchronized (object) {
            this.vane = vane;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vane getVane() {
        Object object = this.vaneLock;
        synchronized (object) {
            return this.vane;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimCancel(boolean cancel) {
        Object object = this.animCancelLock;
        synchronized (object) {
            this.animCancel = cancel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAnimCancel() {
        Object object = this.animCancelLock;
        synchronized (object) {
            return this.animCancel;
        }
    }

    public boolean bannerClick(Banner banner) {
        this.bannerLayout.removeCallbacks(this.reStart);
        this.stop();
        boolean flag1 = banner.isEntered();
        Banner nextEnter = banner.nextEnter;
        boolean flag2 = nextEnter == null && banner.isExitHead() || nextEnter != null && nextEnter.isExited() || banner.isOrigin() && this.enterHead.isExited();
        boolean canShow = flag1 && flag2;
        LogUtil.d(TAG, "bannerClick flag1:" + flag1 + " flag2:" + flag2);
        LogUtil.d(TAG, "bannerClick canShow:" + canShow);
        if (!canShow) {
            this.displayClickBanner(banner);
            this.bannerLayout.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Looper.this.bannerLayout.notifyOnPageShow();
                }
            }, 1000L);
            this.bannerLayout.postDelayed(this.reStart, Banner.DELAY);
        }
        return canShow;
    }

    private void displayClickBanner(Banner banner) {
        LogUtil.d(TAG, "displayClickBanner");
        Banner temp = banner;
        if (banner.isOrigin()) {
            LogUtil.d(TAG, "displayClickBanner banner.position==0");
            temp = this.exitHead;
            temp.exit(0, false);
            while (temp.nextExit != null) {
                temp = temp.nextExit;
                temp.exit(0, false);
            }
            this.setVane(Vane.RIGHT);
            this.runningMan = this.enterHead;
            return;
        }
        switch (banner.getState()) {
            case Entered: 
            case PreEnter: 
            case Entering: {
                LogUtil.d(TAG, "displayClickBanner PreEnter or Entered bammer pos:" + banner.position + " enter getVane():" + (Object)((Object)this.getVane()));
                while (temp.nextEnter != null) {
                    temp = temp.nextEnter;
                    temp.exit(0, false);
                }
                break;
            }
            case Exited: 
            case PreExit: 
            case Exiting: {
                LogUtil.d(TAG, "displayClickBanner Exited banner pos:" + banner.position + " enter getVane():" + (Object)((Object)this.getVane()));
                while (temp.nextExit != null) {
                    temp = temp.nextExit;
                    temp.enter(0, false);
                }
                break;
            }
        }
        if (!banner.isEntered()) {
            banner.enter(0, false);
        }
        switch (this.getVane()) {
            case LEFT: {
                this.runningMan = banner;
                break;
            }
            case RIGHT: {
                if (banner.nextEnter != null) {
                    this.runningMan = banner.nextEnter;
                    break;
                }
                this.setVane(Vane.LEFT);
                this.runningMan = banner;
                break;
            }
        }
    }

    public Banner changeRunningManByScrollDirection(int scrolledX) {
        float runningManViewX = this.runningMan.view.getX();
        if (scrolledX > 0) {
            if (this.runningMan.isEnterHead()) {
                return this.runningMan;
            }
            LogUtil.d(TAG2, "\u5de6\u6ed1 pre runningMan runningManViewX:" + runningManViewX + " runningMan.exitEndX:" + this.runningMan.exitEndX);
            if (runningManViewX == (float)this.runningMan.exitEndX) {
                LogUtil.d(TAG2, " \u5de6\u6ed1 runningMan pos:" + this.runningMan.position + " change to pos:" + this.runningMan.nextExit.position);
                this.runningMan = this.runningMan.nextExit;
            }
        } else {
            if (this.runningMan.isExitHead()) {
                return this.runningMan;
            }
            LogUtil.d(TAG2, "\u53f3\u6ed1 pre runningMan runningManViewX:" + runningManViewX + " runningMan.exitEndX:" + this.runningMan.enterEndX);
            if (runningManViewX == (float)this.runningMan.enterEndX) {
                LogUtil.d(TAG2, " \u53f3\u6ed1 runningMan pos:" + this.runningMan.position + " change to pos:" + this.runningMan.nextEnter.position);
                this.runningMan = this.runningMan.nextEnter;
            }
        }
        return this.runningMan;
    }

    public void changeRunningManOnScrollFinished() {
        ImageView view = this.runningMan.view;
        LogUtil.d(TAG1, "changeRunningManOnScrollFinished: getX" + view.getX() + " runningMan.enterEndX:" + this.runningMan.enterEndX + " runningMan.exitEndX:" + this.runningMan.exitEndX + " pos:" + this.runningMan.position);
        switch (this.getVane()) {
            case LEFT: {
                if (!this.runningMan.isEnterHead() && this.runningMan.isExited()) {
                    LogUtil.d(TAG2, " \u6ed1\u52a8\u7ed3\u675f runningMan pos:" + this.runningMan.position + " change to pos:" + this.runningMan.nextExit.position);
                    this.runningMan = this.runningMan.nextExit;
                    break;
                }
                this.setVane(Vane.RIGHT);
                break;
            }
            case RIGHT: {
                if (!this.runningMan.isExitHead() && this.runningMan.isEntered()) {
                    this.runningMan = this.runningMan.nextEnter;
                    break;
                }
                this.setVane(Vane.LEFT);
                break;
            }
        }
    }

    public Banner getShowingBanner() {
        Banner result = null;
        int size = this.bannerList.size();
        for (int i = size - 1; i >= 0; --i) {
            Banner banner = this.bannerList.get(i);
            if (banner.isExited()) continue;
            result = banner;
            break;
        }
        return result;
    }

    static enum Vane {
        LEFT,
        RIGHT;

    }
}

