/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.banner;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.widget.ImageView;
import sunmi.sunmiui.banner.Looper;
import sunmi.sunmiui.banner.State;
import sunmi.sunmiui.utils.LogUtil;

class Banner {
    private static final String TAG = "Banner";
    static final int DURATION = 1000;
    static int DELAY = 2000;
    static final int TRIM = 35;
    int position;
    int enterEndX = 0;
    int exitEndX;
    Looper looper;
    Banner nextExit;
    Banner nextEnter;
    ObjectAnimator animator = new ObjectAnimator();
    ImageView view;
    private State state;

    public void exit(int delay, final boolean notify) {
        this.animator.cancel();
        this.animator = ObjectAnimator.ofFloat((Object)this.view, (String)"x", (float[])new float[]{this.exitEndX}).setDuration(1000L);
        this.animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                Banner.this.setState(State.Exiting);
                if (notify) {
                    Banner.this.stateChange(State.Exiting);
                }
                LogUtil.d(Banner.TAG, "exit AnimationStart: getX" + Banner.this.view.getX() + " view.getTranslationX" + Banner.this.view.getTranslationX() + " getScrollX:" + Banner.this.view.getScrollX() + " pos:" + Banner.this.position);
            }

            public void onAnimationEnd(Animator animator) {
                Banner.this.setState(State.Exited);
                if (notify) {
                    Banner.this.stateChange(State.Exited);
                }
                LogUtil.d(Banner.TAG, "exit AnimationEnd: getX" + Banner.this.view.getX() + " view.getTranslationX" + Banner.this.view.getTranslationX() + " getScrollX:" + Banner.this.view.getScrollX() + " pos:" + Banner.this.position);
            }

            public void onAnimationCancel(Animator animator) {
                LogUtil.d(Banner.TAG, "exit anim cancel position:" + Banner.this.position);
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.animator.setStartDelay((long)delay);
        this.setState(State.PreExit);
        if (notify) {
            this.stateChange(State.PreExit);
        }
        this.animator.start();
    }

    public void enter(int delay, final boolean notify) {
        this.animator.cancel();
        this.animator = ObjectAnimator.ofFloat((Object)this.view, (String)"x", (float[])new float[]{this.enterEndX}).setDuration(1000L);
        this.animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                Banner.this.setState(State.Entering);
                if (notify) {
                    Banner.this.stateChange(State.Entering);
                }
                LogUtil.d(Banner.TAG, "enter AnimationStart: getX" + Banner.this.view.getX() + " view.getTranslationX" + Banner.this.view.getTranslationX() + " getScrollX:" + Banner.this.view.getScrollX() + " pos:" + Banner.this.position);
            }

            public void onAnimationEnd(Animator animator) {
                Banner.this.setState(State.Entered);
                if (notify) {
                    Banner.this.stateChange(State.Entered);
                }
                LogUtil.d(Banner.TAG, "enter AnimationEnd: getX" + Banner.this.view.getX() + " view.getTranslationX" + Banner.this.view.getTranslationX() + " getScrollX:" + Banner.this.view.getScrollX() + " pos:" + Banner.this.position);
            }

            public void onAnimationCancel(Animator animator) {
                LogUtil.d(Banner.TAG, "enter anim cancel position:" + Banner.this.position);
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.animator.setStartDelay((long)delay);
        this.setState(State.PreEnter);
        if (notify) {
            this.stateChange(State.PreEnter);
        }
        this.animator.start();
    }

    public void cancelAnim() {
        this.animator.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stateChange(State state) {
        if (this.looper.getAnimCancel()) {
            return;
        }
        Banner banner = this;
        synchronized (banner) {
            this.looper.changeRunningManAuto(this, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Banner banner = this;
        synchronized (banner) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State state) {
        Banner banner = this;
        synchronized (banner) {
            this.state = state;
        }
    }

    public boolean isExited() {
        return this.view.getX() == (float)this.exitEndX;
    }

    public boolean isEntered() {
        return this.view.getX() == (float)this.enterEndX;
    }

    public boolean isOrigin() {
        return this.position == 0;
    }

    public boolean isEnterHead() {
        return this.nextExit == null;
    }

    public boolean isExitHead() {
        return this.nextEnter == null;
    }
}

