/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.viewgraoup;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import java.util.List;
import sunmi.sunmiui.R;
import sunmi.sunmiui.utils.Adaptation;
import sunmi.sunmiui.viewgraoup.PagerSlidingTabStrip;
import sunmi.sunmiui.viewgraoup.ViewPagerAdapter;

public class TabViewPager
extends FrameLayout {
    private View mView;
    private ViewPager viewPager;
    private int textSize;
    private PagerSlidingTabStrip tab;
    private RelativeLayout rel_tab;

    public TabViewPager(Context context) {
        super(context);
        this.init();
    }

    public TabViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TabViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mView = this.adapterView();
        this.viewPager = (ViewPager)this.mView.findViewById(R.id.view_pager);
        this.tab = (PagerSlidingTabStrip)this.mView.findViewById(R.id.tab);
        this.rel_tab = (RelativeLayout)this.mView.findViewById(R.id.rel_tab);
        this.tab.setTextSize(this.textSize);
        this.tab.setBackgroundColor(Color.parseColor((String)"#2878f0"));
    }

    public void setSelectedTabTextColorResource(int resId) {
        this.tab.setSelectedTabTextColorResource(resId);
    }

    public void setSelectedTabTextColor(int textColor) {
        this.tab.setSelectedTabTextColor(textColor);
    }

    public void setBackgroundResource(int resId) {
        this.tab.setBackgroundResource(resId);
        this.rel_tab.setBackgroundResource(resId);
    }

    public void setBackgroundColor(int textColor) {
        this.tab.setBackgroundColor(textColor);
        this.rel_tab.setBackgroundColor(textColor);
    }

    public void setIndicatorColorResource(int resId) {
        this.tab.setIndicatorColorResource(resId);
    }

    public void setIndicatorColor(int textColor) {
        this.tab.setIndicatorColor(textColor);
    }

    public void setTextColorResource(int resId) {
        this.tab.setTextColorResource(resId);
    }

    public void setTextColor(int textColor) {
        this.tab.setTextColor(textColor);
    }

    public void setData(List<String> tabStringList, List<View> viewList) throws Exception {
        String error = null;
        if (viewList == null || tabStringList == null) {
            error = "\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3anull";
        }
        if (viewList != null && viewList.size() == 0 || tabStringList != null && tabStringList.size() == 0) {
            error = "\u53c2\u6570\u7684size\u5fc5\u987b\u5927\u4e8e0";
        }
        if (viewList != null && tabStringList != null && viewList.size() == 0 && tabStringList.size() == 0 && viewList.size() != tabStringList.size()) {
            error = "\u53c2\u6570\u7684size\u5fc5\u987b\u76f8\u7b49";
        }
        if (!TextUtils.isEmpty((CharSequence)error)) {
            try {
                throw new Exception(error);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.viewPager.setAdapter((PagerAdapter)new ViewPagerAdapter(tabStringList, viewList));
        this.tab.setViewPager(this.viewPager);
    }

    private View adapterView() {
        switch (Adaptation.proportion) {
            case 1: {
                this.textSize = 13;
                return View.inflate((Context)this.getContext(), (int)R.layout.view_tab_view_pager_9_16, (ViewGroup)this);
            }
            case 2: {
                this.textSize = 13;
                return View.inflate((Context)this.getContext(), (int)R.layout.view_tab_view_pager_9_16, (ViewGroup)this);
            }
            case 3: {
                this.textSize = 16;
                return View.inflate((Context)this.getContext(), (int)R.layout.view_tab_view_pager_16_9, (ViewGroup)this);
            }
            case 4: {
                this.textSize = 16;
                return View.inflate((Context)this.getContext(), (int)R.layout.view_tab_view_pager_16_9, (ViewGroup)this);
            }
        }
        this.textSize = 13;
        return View.inflate((Context)this.getContext(), (int)R.layout.view_tab_view_pager_9_16, (ViewGroup)this);
    }
}

