/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import sunmi.sunmiui.R;

public abstract class SettingItemView
extends FrameLayout {
    protected TextView topTextView;
    protected TextView bottomTextView;
    protected View bg;
    protected LinearLayout linearLayout;

    public SettingItemView(Context context) {
        super(context);
        this.init();
    }

    public SettingItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SettingItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    void init() {
        View view = this.createView();
        this.topTextView = (TextView)view.findViewById(R.id.text_top);
        this.bottomTextView = (TextView)view.findViewById(R.id.text_bottom);
        this.bg = view.findViewById(R.id.bg);
        this.linearLayout = (LinearLayout)view.findViewById(R.id.linearlayout);
    }

    public void setText(String topStr, String bottomStr) {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.addRule(15);
        this.linearLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (TextUtils.isEmpty((CharSequence)topStr) && !TextUtils.isEmpty((CharSequence)bottomStr)) {
            this.topTextView.setVisibility(8);
            this.bottomTextView.setText((CharSequence)bottomStr);
        } else if (!TextUtils.isEmpty((CharSequence)topStr) && TextUtils.isEmpty((CharSequence)bottomStr)) {
            this.bottomTextView.setVisibility(8);
            this.topTextView.setText((CharSequence)topStr);
        } else if (!TextUtils.isEmpty((CharSequence)topStr) && !TextUtils.isEmpty((CharSequence)bottomStr)) {
            this.topTextView.setText((CharSequence)topStr);
            this.bottomTextView.setText((CharSequence)bottomStr);
        }
    }

    @TargetApi(value=16)
    public void setBackground(Drawable drawable2) {
        this.bg.setBackground(drawable2);
    }

    public void setTextColor(int topColor, int bottomColor) {
        this.topTextView.setTextColor(topColor);
        this.bottomTextView.setTextColor(bottomColor);
    }

    public void setTextSize(float topSize, float bottomSize) {
        this.topTextView.setTextSize(topSize);
        this.bottomTextView.setTextSize(bottomSize);
    }

    protected abstract View createView();

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.bg.getLayoutParams();
        layoutParams.width = width;
        this.bg.setLayoutParams(layoutParams);
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.bg.getLayoutParams();
        layoutParams.height = height;
        this.bg.setLayoutParams(layoutParams);
    }

    public void setOnclickListener(View.OnClickListener onclickListener) {
        this.bg.setOnClickListener(onclickListener);
    }

    public void setClickable(boolean clickable) {
        this.bg.setClickable(clickable);
    }
}

