/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.refreshlistview;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.RelativeLayout;
import sunmi.sunmiui.R;

public class PullToRefreshSwipeLayout
extends SwipeRefreshLayout {
    private OnPullUpListener mOnPullUpListener;
    private ListView mListView;
    private View mFooterView;
    private RelativeLayout nodata_layout;
    private RelativeLayout loading_layout;
    private float mDownY;
    private float mLastY;
    private float mTouchDistance = 50.0f;
    private boolean isPullLoading = false;
    public static final int NONE = 1;
    public static final int LOADING = 2;
    public static final int NODATA = 3;
    private OnSlideListener mOnSlideListener;
    private AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (PullToRefreshSwipeLayout.this.mOnPullUpListener != null && !PullToRefreshSwipeLayout.this.isRefreshing() && PullToRefreshSwipeLayout.this.isBottom() && PullToRefreshSwipeLayout.this.isPullUp() && !PullToRefreshSwipeLayout.this.isPullLoading) {
                PullToRefreshSwipeLayout.this.setViewStatus(2);
                PullToRefreshSwipeLayout.this.mOnPullUpListener.onPullUp();
            }
        }
    };

    public void setOnPullUpListener(OnPullUpListener listener) {
        this.mOnPullUpListener = listener;
    }

    public PullToRefreshSwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private void initView() {
        this.setColorSchemeResources(new int[]{R.color.pbColor});
        this.mFooterView = View.inflate((Context)this.getContext(), (int)R.layout.item_footer, null);
        this.nodata_layout = (RelativeLayout)this.mFooterView.findViewById(R.id.nodata_layout);
        this.loading_layout = (RelativeLayout)this.mFooterView.findViewById(R.id.loading_layout);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mListView == null) {
            this.getListView();
        }
    }

    private void getListView() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof ListView)) continue;
                this.mListView = (ListView)child;
                this.mListView.setOnScrollListener(this.onScrollListener);
                break;
            }
        }
    }

    public synchronized void setViewStatus(int status) {
        this.mDownY = 0.0f;
        this.mLastY = 0.0f;
        this.nodata_layout.setVisibility(8);
        this.loading_layout.setVisibility(0);
        switch (status) {
            case 1: {
                this.isPullLoading = false;
                this.nodata_layout.setVisibility(0);
                this.loading_layout.setVisibility(8);
                break;
            }
            case 2: {
                this.isPullLoading = true;
                this.removeFooterView();
                this.addFooterView();
                break;
            }
            case 3: {
                this.isPullLoading = false;
                this.removeFooterView();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mListView == null || this.mOnPullUpListener == null) {
            return super.dispatchTouchEvent(ev);
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mDownY = ev.getY();
                break;
            }
            case 2: {
                this.mLastY = ev.getY();
                if (this.mDownY > ev.getY()) {
                    if (this.mOnSlideListener == null) break;
                    this.mOnSlideListener.up();
                    break;
                }
                if (!(this.mDownY < ev.getY()) || this.mOnSlideListener == null) break;
                this.mOnSlideListener.down();
                break;
            }
            case 1: {
                this.mLastY = ev.getY();
                if (!this.isRefreshing() && this.isBottom() && this.isPullUp() && !this.isPullLoading) {
                    this.setViewStatus(2);
                    this.mOnPullUpListener.onPullUp();
                    break;
                }
                if (this.canChildScrollUp() || !this.isDropDown()) break;
                this.removeFooterView();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void addFooterView() {
        if (this.mFooterView != null && this.mListView != null) {
            this.mListView.addFooterView(this.mFooterView);
        }
    }

    private void removeFooterView() {
        if (this.mFooterView != null && this.mListView != null) {
            this.mListView.removeFooterView(this.mFooterView);
        }
    }

    private boolean isBottom() {
        if (this.mListView != null && this.mListView.getAdapter() != null) {
            return this.mListView.getLastVisiblePosition() == this.mListView.getAdapter().getCount() - 1;
        }
        return false;
    }

    private boolean isPullUp() {
        return this.mDownY - this.mLastY >= this.mTouchDistance;
    }

    private boolean isDropDown() {
        return this.mDownY - this.mLastY <= -this.mTouchDistance;
    }

    public void setOnSlideListener(OnSlideListener onSlideListener) {
        this.mOnSlideListener = onSlideListener;
    }

    public static interface OnSlideListener {
        public void up();

        public void down();
    }

    public static interface OnPullUpListener {
        public void onPullUp();
    }
}

