/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.flexible;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import sunmi.sunmiui.flexible.Flexible;
import sunmi.sunmiui.utils.LogUtil;

public class FlexibleEffect {
    private static final String TAG = "FlexibleEffect";
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_ABSORB = 2;
    private View view;
    private Flexible flexibleView;
    private int mState = 0;
    private float maxScaleY = 1.5f;
    private final float minScaleY = 1.0f;
    private float currentScaleY = 1.0f;
    ObjectAnimator absorbAnimator = new ObjectAnimator();
    ObjectAnimator flingAnimator = new ObjectAnimator();
    private long mDuration;
    private static final int MIN_VELOCITY = 100;
    private static final int MAX_VELOCITY = 10000;
    private float resistance = 8.0f;
    private static final long MAX_DURATION = 300L;
    private boolean topFlexible = true;

    public FlexibleEffect(View view) {
        this.view = view;
        this.flexibleView = (Flexible)view;
    }

    public void setMaxScaleY(int scaleY) {
        this.maxScaleY = scaleY;
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public boolean isPulling() {
        return this.mState == 1;
    }

    public boolean isAbsorbing() {
        return this.mState == 2;
    }

    public void finish() {
        this.absorbAnimator.cancel();
        this.mState = 0;
    }

    public void setResistance(float resistance) {
        this.resistance = resistance;
    }

    public synchronized void onPull(float scaleYIncrement) {
        LogUtil.d(TAG, "onPull scaleYIncrement:" + (scaleYIncrement /= this.resistance));
        if (this.flexibleView.isTop()) {
            if (!this.topFlexible) {
                return;
            }
            this.currentScaleY -= scaleYIncrement;
            this.view.setPivotY(0.0f);
        } else if (this.flexibleView.isBottom()) {
            this.currentScaleY += scaleYIncrement;
            this.view.setPivotY((float)this.view.getHeight());
        }
        if (this.currentScaleY > this.maxScaleY) {
            this.currentScaleY = this.maxScaleY;
        } else if (this.currentScaleY < 1.0f) {
            this.currentScaleY = 1.0f;
        }
        if (this.currentScaleY <= this.maxScaleY && this.currentScaleY >= 1.0f) {
            this.mState = 1;
            this.view.setScaleY(this.currentScaleY);
            if (this.currentScaleY == 1.0f) {
                this.onRelease();
            }
        }
    }

    public void onRelease() {
        this.mState = 0;
        this.currentScaleY = 1.0f;
    }

    public void onAbsorb(long duration) {
        if (this.flexibleView.isTop() && !this.topFlexible) {
            return;
        }
        this.absorbAnimator.cancel();
        this.mState = 2;
        if (duration == -1L) {
            this.mDuration = (long)(this.currentScaleY / this.maxScaleY * 300.0f);
            LogUtil.d(TAG, "onAbsorb1 mDuration:" + this.mDuration);
        } else {
            LogUtil.d(TAG, "onAbsorb2");
            this.mDuration = duration;
        }
        this.absorbAnimator = ObjectAnimator.ofFloat((Object)this.view, (String)"scaleY", (float[])new float[]{1.0f}).setDuration(this.mDuration);
        this.absorbAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.absorbAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                FlexibleEffect.this.onRelease();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.absorbAnimator.start();
    }

    public void onFling(float velocity) {
        LogUtil.d(TAG, "onFling velocity:" + velocity + " " + !this.isFinished() + " " + !this.flexibleView.isBottom() + " " + !this.flexibleView.isTop());
        if (!this.isFinished() || !this.flexibleView.isBottom() && !this.flexibleView.isTop()) {
            return;
        }
        if (this.flexibleView.isTop()) {
            if (!this.topFlexible) {
                return;
            }
            this.view.setPivotY(0.0f);
        } else if (this.flexibleView.isBottom()) {
            this.view.setPivotY((float)this.view.getHeight());
        }
        velocity = Math.min(Math.max(100.0f, Math.abs(velocity)), 10000.0f);
        this.flingAnimator.cancel();
        this.mState = 1;
        this.mDuration = (long)(20.0 + (double)velocity * 0.02);
        float scaleY = (float)this.mDuration / 300.0f * (this.maxScaleY - 1.0f);
        LogUtil.d(TAG, "onFling mDuration=" + this.mDuration + " scaleY:" + (scaleY *= 0.2f));
        this.flingAnimator = ObjectAnimator.ofFloat((Object)this.view, (String)"scaleY", (float[])new float[]{1.0f + scaleY}).setDuration(this.mDuration);
        this.flingAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                FlexibleEffect.this.onAbsorb(300L);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.flingAnimator.start();
    }

    public void setTopFlexible(boolean topFlexible) {
        this.topFlexible = topFlexible;
    }
}

