/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import sunmi.sunmiui.R;

public abstract class TitleView
extends FrameLayout {
    protected TextView textView;
    protected View bg;

    public TitleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public TitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TitleView(Context context) {
        super(context);
        this.init();
    }

    void init() {
        View view = this.createView();
        this.textView = (TextView)view.findViewById(R.id.text);
        this.bg = view.findViewById(R.id.bg);
    }

    protected abstract View createView();

    public void setTitleText(String titleStr) {
        this.textView.setText((CharSequence)titleStr);
    }

    @TargetApi(value=16)
    public void setBackground(Drawable drawable2) {
        this.bg.setBackground(drawable2);
    }

    public void setBackgroundColor(int color2) {
        this.bg.setBackgroundColor(color2);
    }

    public void setTextColor(int color2) {
        this.textView.setTextColor(color2);
    }

    public void setTextSize(float size) {
        this.textView.setTextSize(size);
    }

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.bg.getLayoutParams();
        layoutParams.width = width;
        this.bg.setLayoutParams(layoutParams);
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.bg.getLayoutParams();
        layoutParams.height = height;
        this.bg.setLayoutParams(layoutParams);
    }

    public void addTitleRule(int verb) {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.addRule(verb);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }
}

