/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import sunmi.sunmiui.R;
import sunmi.sunmiui.dialog.BaseDialog;

public class LoadingDialog
extends BaseDialog {
    private static LoadingDialog instance;
    private TextView loadingMsg;
    private View loadingProgress;

    private LoadingDialog() {
    }

    public static LoadingDialog getInstance() {
        if (instance == null) {
            instance = new LoadingDialog();
        }
        return instance;
    }

    @Override
    protected void init() {
        this.loadingProgress = this.dialog.findViewById(R.id.progress);
        this.loadingMsg = (TextView)this.dialog.findViewById(R.id.msg);
    }

    @Override
    protected void onDialogCancel() {
        this.dialog = null;
        instance = null;
    }

    @Override
    public void show() {
        super.show();
        if (this.dialog != null && this.dialog.getContext() != null) {
            Animation operatingAnim = AnimationUtils.loadAnimation((Context)this.dialog.getContext(), (int)R.anim.loading_anim);
            LinearInterpolator lin = new LinearInterpolator();
            operatingAnim.setInterpolator((Interpolator)lin);
            this.loadingProgress.setAnimation(operatingAnim);
            this.loadingProgress.startAnimation(operatingAnim);
        }
    }

    public void setLoadingMsgSize(int size) {
        this.loadingMsg.setTextSize(2, (float)size);
    }
}

