/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EdgeEffect;
import sunmi.sunmiui.R;
import sunmi.sunmiui.utils.LogUtil;

public class FadingEdgeView
extends ViewGroup {
    private static final String TAG = "FadingEdgeView";
    private TextPaint mTextPaint;
    private float mTextWidth;
    private float mTextHeight;
    private EdgeEffect mEdgeGlowLeft;
    private EdgeEffect mEdgeGlowRight;
    private float mXDown;
    private float mXLastMove;
    private float mXMove;

    public FadingEdgeView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public FadingEdgeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public FadingEdgeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.setWillNotDraw(false);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FadingEdgeView, defStyle, 0);
        a.recycle();
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setFlags(1);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.invalidateTextPaintAndMeasurements();
    }

    private void invalidateTextPaintAndMeasurements() {
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.mTextHeight = fontMetrics.bottom;
    }

    public boolean onTouchEvent(MotionEvent event) {
        LogUtil.d(TAG, "onTouchEvent event:" + event.getAction());
        switch (event.getAction()) {
            case 0: {
                LogUtil.d(TAG, "onTouchEvent ACTION_DOWN");
                this.mXLastMove = this.mXDown = event.getRawX();
                break;
            }
            case 2: {
                LogUtil.d(TAG, "onTouchEvent ACTION_MOVE");
                this.mXMove = event.getRawX();
                float diff = Math.abs(this.mXMove - this.mXDown);
                this.mXLastMove = this.mXMove;
                this.canOverScroll(event);
                break;
            }
            case 1: {
                LogUtil.d(TAG, "onTouchEvent ACTION_UP");
                break;
            }
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int contentWidth = this.getWidth() - paddingLeft - paddingRight;
        int contentHeight = this.getHeight() - paddingTop - paddingBottom;
        canvas.rotate(10.0f);
        canvas.translate((float)(this.getWidth() / 3), 50.0f);
        Paint p = new Paint();
        p.setColor(-65536);
        canvas.drawText("\u753b\u5706\uff1a", 10.0f, 20.0f, p);
        canvas.drawCircle(60.0f, 20.0f, 10.0f, p);
        p.setAntiAlias(true);
        canvas.drawCircle(120.0f, 20.0f, 20.0f, p);
        int scrolledX = (int)(this.mXLastMove - this.mXMove);
        if (this.mEdgeGlowLeft != null) {
            int restoreCount;
            int scrollX = scrolledX;
            if (!this.mEdgeGlowLeft.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                this.mEdgeGlowLeft.setSize(height, this.getWidth());
                if (this.mEdgeGlowLeft.draw(canvas)) {
                    this.postInvalidate();
                }
                canvas.restoreToCount(restoreCount);
                Log.d((String)TAG, (String)"mEdgeGlowLeft canvas.restoreToCount(restoreCount)");
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                this.mEdgeGlowRight.setSize(height, width);
                if (this.mEdgeGlowRight.draw(canvas)) {
                    this.postInvalidate();
                }
                canvas.restoreToCount(restoreCount);
                Log.d((String)TAG, (String)"mEdgeGlowRight canvas.restoreToCount(restoreCount)");
            }
        }
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getWidth() - (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()));
        }
        return scrollRange;
    }

    private void canOverScroll(MotionEvent ev) {
        boolean canOverscroll;
        Log.d((String)TAG, (String)"canOverScroll");
        int mActivePointerId = ev.getPointerId(0);
        int activePointerIndex = ev.findPointerIndex(mActivePointerId);
        if (activePointerIndex == -1) {
            LogUtil.e(TAG, "Invalid pointerId=" + mActivePointerId + " in onTouchEvent");
            return;
        }
        int scrolledX = (int)(this.mXLastMove - this.mXMove);
        if (scrolledX < 0) {
            // empty if block
        }
        int deltaX = scrolledX;
        int oldX = (int)ev.getX();
        int range = this.getScrollRange();
        int overscrollMode = this.getOverScrollMode();
        boolean bl = canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
        if (canOverscroll) {
            int pulledToX = oldX + 10;
            if (pulledToX < 0) {
                this.mEdgeGlowRight.onPull((float)deltaX / (float)this.getWidth());
                if (!this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onRelease();
                }
            } else if (pulledToX > range) {
                this.mEdgeGlowRight.onPull((float)deltaX / (float)this.getWidth());
                if (!this.mEdgeGlowLeft.isFinished()) {
                    this.mEdgeGlowLeft.onRelease();
                }
            }
            if (!(this.mEdgeGlowLeft == null || this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished())) {
                this.postInvalidate();
            }
        }
    }

    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowLeft == null) {
                Context context = this.getContext();
                this.mEdgeGlowLeft = new EdgeEffect(context);
                this.mEdgeGlowRight = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
        super.setOverScrollMode(mode);
    }
}

