/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.peripheral.printer;

import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.sunmi.peripheral.printer.ICallback;
import com.sunmi.peripheral.printer.ILcdCallback;
import com.sunmi.peripheral.printer.ITax;
import com.sunmi.peripheral.printer.InnerLcdCallback;
import com.sunmi.peripheral.printer.InnerPrinterException;
import com.sunmi.peripheral.printer.InnerResultCallback;
import com.sunmi.peripheral.printer.InnerTaxCallback;
import com.sunmi.peripheral.printer.TransBean;
import java.util.Locale;

public interface SunmiPrinterService
extends IInterface {
    public void updateFirmware() throws RemoteException;

    public int getFirmwareStatus() throws RemoteException;

    public String getServiceVersion() throws RemoteException;

    public void printerInit(InnerResultCallback var1) throws RemoteException;

    public void printerSelfChecking(InnerResultCallback var1) throws RemoteException;

    public String getPrinterSerialNo() throws RemoteException;

    public String getPrinterVersion() throws RemoteException;

    public String getPrinterModal() throws RemoteException;

    public void getPrintedLength(InnerResultCallback var1) throws RemoteException;

    public void lineWrap(int var1, InnerResultCallback var2) throws RemoteException;

    public void sendRAWData(byte[] var1, InnerResultCallback var2) throws RemoteException;

    public void setAlignment(int var1, InnerResultCallback var2) throws RemoteException;

    public void setFontName(String var1, InnerResultCallback var2) throws RemoteException;

    public void setFontSize(float var1, InnerResultCallback var2) throws RemoteException;

    public void printText(String var1, InnerResultCallback var2) throws RemoteException;

    public void printTextWithFont(String var1, String var2, float var3, InnerResultCallback var4) throws RemoteException;

    public void printColumnsText(String[] var1, int[] var2, int[] var3, InnerResultCallback var4) throws RemoteException;

    public void printBitmap(Bitmap var1, InnerResultCallback var2) throws RemoteException;

    public void printBarCode(String var1, int var2, int var3, int var4, int var5, InnerResultCallback var6) throws RemoteException;

    public void printQRCode(String var1, int var2, int var3, InnerResultCallback var4) throws RemoteException;

    public void printOriginalText(String var1, InnerResultCallback var2) throws RemoteException;

    public void commitPrint(TransBean[] var1, InnerResultCallback var2) throws RemoteException;

    public void commitPrinterBuffer() throws RemoteException;

    public void cutPaper(InnerResultCallback var1) throws RemoteException;

    public int getCutPaperTimes() throws RemoteException;

    public void openDrawer(InnerResultCallback var1) throws RemoteException;

    public int getOpenDrawerTimes() throws RemoteException;

    public void enterPrinterBuffer(boolean var1) throws RemoteException;

    public void exitPrinterBuffer(boolean var1) throws RemoteException;

    public void tax(byte[] var1, InnerTaxCallback var2) throws RemoteException;

    public void getPrinterFactory(InnerResultCallback var1) throws RemoteException;

    public void clearBuffer() throws RemoteException;

    public void commitPrinterBufferWithCallback(InnerResultCallback var1) throws RemoteException;

    public void exitPrinterBufferWithCallback(boolean var1, InnerResultCallback var2) throws RemoteException;

    public void printColumnsString(String[] var1, int[] var2, int[] var3, InnerResultCallback var4) throws RemoteException;

    public int updatePrinterState() throws RemoteException;

    public void sendLCDCommand(int var1) throws RemoteException;

    public void sendLCDString(String var1, InnerLcdCallback var2) throws RemoteException;

    public void sendLCDBitmap(Bitmap var1, InnerLcdCallback var2) throws RemoteException;

    public int getPrinterMode() throws RemoteException;

    public int getPrinterBBMDistance() throws RemoteException;

    public void printBitmapCustom(Bitmap var1, int var2, InnerResultCallback var3) throws RemoteException;

    public int getForcedDouble() throws RemoteException;

    public boolean isForcedAntiWhite() throws RemoteException;

    public boolean isForcedBold() throws RemoteException;

    public boolean isForcedUnderline() throws RemoteException;

    public int getForcedRowHeight() throws RemoteException;

    public int getFontName() throws RemoteException;

    public void sendLCDDoubleString(String var1, String var2, InnerLcdCallback var3) throws RemoteException;

    public int getPrinterPaper() throws RemoteException;

    public boolean getDrawerStatus() throws RemoteException;

    public void sendLCDFillString(String var1, int var2, boolean var3, InnerLcdCallback var4) throws RemoteException;

    public void sendLCDMultiString(String[] var1, int[] var2, InnerLcdCallback var3) throws RemoteException;

    public int getPrinterDensity() throws RemoteException;

    public void print2DCode(String var1, int var2, int var3, int var4, InnerResultCallback var5) throws RemoteException;

    public void autoOutPaper(InnerResultCallback var1) throws RemoteException;

    public void setPrinterStyle(int var1, int var2) throws RemoteException;

    public void labelLocate() throws RemoteException;

    public void labelOutput() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements SunmiPrinterService {
        private static final String DESCRIPTOR = "woyou.aidlservice.jiuiv5.IWoyouService";
        static final int[][] TRANSCTION_DATASHEET = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 5, 9527, 0, -9, -9, -9, -9, -9, -9, -9, 9527, -8, 9527, 9527, 9527, -14, -14, -13, -13, -12, -12}, {-1, 3, 3, 3, 9527, 9527, 8, 8, 1, 1, -10, -10, -10, -10, -3, -3, -3, -10, -10, 9527, -2, 9527, 9527, 9527, 9527, 9527, 9527, -10, -4, -10, -10, -10, -10, -10, -9, -9, 9527, 9527}, {0, 0, 0, 9527, 9527, 9527, 9527, 9527, -5, 7, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 9527, 0, -15, -15, -15, -15, -15, -15, -15, 9527, -14, 9527, 9527, 9527, -20, -20, -19, -19, 9527, 9527}, {-1, 3, 3, 3, 9527, 9527, 5, 5, 1, 1, -10, -10, -10, -10, 9527, 9527, 9527, -10, -10, 9527, -6, 9527, 9527, 9527, 9527, 9527, 9527, 9527, -13, -13, 9527, 9527, -15, -15, 9527, -16, 9527, 9527}};
        static final int TRANSACTION_STOP = 9527;
        static final int TRANSACTION_updateFirmware = 1;
        static final int TRANSACTION_getFirmwareStatus = 2;
        static final int TRANSACTION_getServiceVersion = 3;
        static final int TRANSACTION_printerInit = 4;
        static final int TRANSACTION_printerSelfChecking = 5;
        static final int TRANSACTION_getPrinterSerialNo = 6;
        static final int TRANSACTION_getPrinterVersion = 7;
        static final int TRANSACTION_getPrinterModal = 8;
        static final int TRANSACTION_getPrintedLength = 9;
        static final int TRANSACTION_lineWrap = 10;
        static final int TRANSACTION_sendRAWData = 11;
        static final int TRANSACTION_setAlignment = 12;
        static final int TRANSACTION_setFontName = 13;
        static final int TRANSACTION_setFontSize = 14;
        static final int TRANSACTION_printText = 15;
        static final int TRANSACTION_printTextWithFont = 16;
        static final int TRANSACTION_printColumnsText = 17;
        static final int TRANSACTION_printBitmap = 18;
        static final int TRANSACTION_printBarCode = 19;
        static final int TRANSACTION_printQRCode = 20;
        static final int TRANSACTION_printOriginalText = 21;
        static final int TRANSACTION_commitPrint = 22;
        static final int TRANSACTION_commitPrinterBuffer = 23;
        static final int TRANSACTION_enterPrinterBuffer = 24;
        static final int TRANSACTION_exitPrinterBuffer = 25;
        static final int TRANSACTION_tax = 26;
        static final int TRANSACTION_getPrinterFactory = 27;
        static final int TRANSACTION_clearBuffer = 28;
        static final int TRANSACTION_commitPrinterBufferWithCallback = 29;
        static final int TRANSACTION_exitPrinterBufferWithCallback = 30;
        static final int TRANSACTION_printColumnsString = 31;
        static final int TRANSACTION_updatePrinterState = 32;
        static final int TRANSACTION_cutPaper = 33;
        static final int TRANSACTION_getCutPaperTimes = 34;
        static final int TRANSACTION_openDrawer = 35;
        static final int TRANSACTION_getOpenDrawerTimes = 36;
        static final int TRANSACTION_sendLCDCommand = 37;
        static final int TRANSACTION_sendLCDString = 38;
        static final int TRANSACTION_sendLCDBitmap = 39;
        static final int TRANSACTION_getPrinterMode = 40;
        static final int TRANSACTION_getPrinterBBMDistance = 41;
        static final int TRANSACTION_printBitmapCustom = 42;
        static final int TRANSACTION_getForcedDouble = 43;
        static final int TRANSACTION_isForcedAntiWhite = 44;
        static final int TRANSACTION_isForcedBold = 45;
        static final int TRANSACTION_isForcedUnderline = 46;
        static final int TRANSACTION_getForcedRowHeight = 47;
        static final int TRANSACTION_getFontName = 48;
        static final int TRANSACTION_sendLCDDoubleString = 49;
        static final int TRANSACTION_getPrinterPaper = 50;
        static final int TRANSACTION_getDrawerStatus = 51;
        static final int TRANSACTION_sendLCDFillString = 52;
        static final int TRANSACTION_sendLCDMultiString = 53;
        static final int TRANSACTION_getPrinterDensity = 54;
        static final int TRANSACTION_print2DCode = 55;
        static final int TRANSACTION_autoOutPaper = 56;
        static final int TRANSACTION_setPrinterStyle = 57;
        static final int TRANSACTION_labelLocate = 58;
        static final int TRANSACTION_labelOutput = 59;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static SunmiPrinterService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof SunmiPrinterService) {
                return (SunmiPrinterService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.updateFirmware();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getFirmwareStatus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getServiceVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printerInit(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printerSelfChecking(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getPrinterSerialNo();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getPrinterVersion();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getPrinterModal();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.getPrintedLength(_arg0);
                    int _result = 0;
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.lineWrap(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _arg0 = data.createByteArray();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.sendRAWData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.setAlignment(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.setFontName(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    float _arg0 = data.readFloat();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.setFontSize(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printText(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    float _arg2 = data.readFloat();
                    InnerResultCallback _arg3 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printTextWithFont(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    String[] _arg0 = data.createStringArray();
                    int[] _arg1 = data.createIntArray();
                    int[] _arg2 = data.createIntArray();
                    InnerResultCallback _arg3 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printColumnsText(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    Bitmap _arg0 = 0 != data.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(data) : null;
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printBitmap(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    InnerResultCallback _arg5 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printBarCode(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    InnerResultCallback _arg3 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printQRCode(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printOriginalText(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    TransBean[] _arg0 = (TransBean[])data.createTypedArray(TransBean.CREATOR);
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.commitPrint(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    this.commitPrinterBuffer();
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.cutPaper(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getCutPaperTimes();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.openDrawer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getOpenDrawerTimes();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.enterPrinterBuffer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.exitPrinterBuffer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _arg0 = data.createByteArray();
                    InnerTaxCallback _arg1 = (InnerTaxCallback)ITax.Stub.asInterface(data.readStrongBinder());
                    this.tax(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.getPrinterFactory(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    this.clearBuffer();
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.commitPrinterBufferWithCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    InnerResultCallback _arg1 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.exitPrinterBufferWithCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    String[] _arg0 = data.createStringArray();
                    int[] _arg1 = data.createIntArray();
                    int[] _arg2 = data.createIntArray();
                    InnerResultCallback _arg3 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printColumnsString(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.updatePrinterState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.sendLCDCommand(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    InnerLcdCallback _arg1 = (InnerLcdCallback)ILcdCallback.Stub.asInterface(data.readStrongBinder());
                    this.sendLCDString(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(DESCRIPTOR);
                    Bitmap _arg0 = 0 != data.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(data) : null;
                    InnerLcdCallback _arg1 = (InnerLcdCallback)ILcdCallback.Stub.asInterface(data.readStrongBinder());
                    this.sendLCDBitmap(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getPrinterMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 41: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getPrinterBBMDistance();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 42: {
                    data.enforceInterface(DESCRIPTOR);
                    Bitmap _arg0 = 0 != data.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    InnerResultCallback _arg2 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.printBitmapCustom(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getForcedDouble();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 44: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isForcedAntiWhite();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 45: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isForcedBold();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isForcedUnderline();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 47: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getForcedRowHeight();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 48: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getFontName();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 49: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    InnerLcdCallback _arg2 = (InnerLcdCallback)ILcdCallback.Stub.asInterface(data.readStrongBinder());
                    this.sendLCDDoubleString(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getPrinterPaper();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 51: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.getDrawerStatus();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 52: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    InnerLcdCallback _arg3 = (InnerLcdCallback)ILcdCallback.Stub.asInterface(data.readStrongBinder());
                    this.sendLCDFillString(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(DESCRIPTOR);
                    String[] _arg0 = data.createStringArray();
                    int[] _arg1 = data.createIntArray();
                    InnerLcdCallback _arg2 = (InnerLcdCallback)ILcdCallback.Stub.asInterface(data.readStrongBinder());
                    this.sendLCDMultiString(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getPrinterDensity();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 55: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    InnerResultCallback _arg4 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.print2DCode(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(DESCRIPTOR);
                    InnerResultCallback _arg0 = (InnerResultCallback)ICallback.Stub.asInterface(data.readStrongBinder());
                    this.autoOutPaper(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setPrinterStyle(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface(DESCRIPTOR);
                    this.labelLocate();
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface(DESCRIPTOR);
                    this.labelOutput();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static class Proxy
        implements SunmiPrinterService {
            private IBinder mRemote;
            private int[] transaction_table;

            Proxy(IBinder remote) {
                this.mRemote = remote;
                this.setTable();
            }

            private void setTable() {
                String model = Build.MODEL.toUpperCase(Locale.ENGLISH);
                this.transaction_table = model.contains("V2") || model.contains("P2") || model.contains("P1") || model.contains("V1S") || "QBAO_H1".equals(model) ? TRANSCTION_DATASHEET[0] : (model.contains("MINI") && (model.contains("T1") || model.contains("T2")) ? TRANSCTION_DATASHEET[1] : (model.contains("V1") ? TRANSCTION_DATASHEET[2] : (model.contains("T1") || model.contains("T2") || model.contains("S2") ? TRANSCTION_DATASHEET[3] : TRANSCTION_DATASHEET[3])));
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void updateFirmware() throws RemoteException {
                throw new InnerPrinterException("only system calls are supported");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFirmwareStatus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getServiceVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printerInit(InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printerSelfChecking(InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _reply.readException();
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(5, _data, _reply, 0);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrinterSerialNo() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrinterVersion() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrinterModal() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrintedLength(InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    if (_reply.dataAvail() == 4) {
                        int _result = _reply.readInt();
                        if (callback != null && _result != -1) {
                            callback.onReturnString(String.valueOf(_result));
                        }
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lineWrap(int n, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(n);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRAWData(byte[] data, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAlignment(int alignment, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(alignment);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFontName(String typeface, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(typeface);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFontSize(float fontsize, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(fontsize);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printText(String text, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printTextWithFont(String text, String typeface, float fontsize, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeString(typeface);
                    _data.writeFloat(fontsize);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printColumnsText(String[] colsTextArr, int[] colsWidthArr, int[] colsAlign, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(colsTextArr);
                    _data.writeIntArray(colsWidthArr);
                    _data.writeIntArray(colsAlign);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printBitmap(Bitmap bitmap, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        _data.writeInt(1);
                        bitmap.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printBarCode(String data, int symbology, int height, int width, int textposition, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(data);
                    _data.writeInt(symbology);
                    _data.writeInt(height);
                    _data.writeInt(width);
                    _data.writeInt(textposition);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printQRCode(String data, int modulesize, int errorlevel, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(data);
                    _data.writeInt(modulesize);
                    _data.writeInt(errorlevel);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printOriginalText(String text, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitPrint(TransBean[] transbean, InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[19] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray((Parcelable[])transbean, 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(22, _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitPrinterBuffer() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(23 + this.transaction_table[0], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cutPaper(InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[10] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(33 + this.transaction_table[10], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCutPaperTimes() throws RemoteException {
                int _result;
                if (this.transaction_table[11] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(34 + this.transaction_table[11], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openDrawer(InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[12] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(35 + this.transaction_table[12], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getOpenDrawerTimes() throws RemoteException {
                int _result;
                if (this.transaction_table[13] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(36 + this.transaction_table[13], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enterPrinterBuffer(boolean clean) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clean ? 1 : 0);
                    boolean res = this.mRemote.transact(24 + this.transaction_table[1], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitPrinterBuffer(boolean commit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(commit ? 1 : 0);
                    boolean res = this.mRemote.transact(25 + this.transaction_table[2], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tax(byte[] data, InnerTaxCallback callback) throws RemoteException {
                if (this.transaction_table[3] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(26 + this.transaction_table[3], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrinterFactory(InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[4] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(27 + this.transaction_table[4], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBuffer() throws RemoteException {
                if (this.transaction_table[5] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(28 + this.transaction_table[5], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitPrinterBufferWithCallback(InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[6] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(29 + this.transaction_table[6], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitPrinterBufferWithCallback(boolean commit, InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[6] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(commit ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(30 + this.transaction_table[7], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printColumnsString(String[] colsTextArr, int[] colsWidthArr, int[] colsAlign, InnerResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(colsTextArr);
                    _data.writeIntArray(colsWidthArr);
                    _data.writeIntArray(colsAlign);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(31 + this.transaction_table[8], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updatePrinterState() throws RemoteException {
                int _result;
                if (this.transaction_table[9] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(32 + this.transaction_table[9], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDCommand(int flag) throws RemoteException {
                if (this.transaction_table[14] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flag);
                    boolean res = this.mRemote.transact(37 + this.transaction_table[14], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDString(String string, InnerLcdCallback callback) throws RemoteException {
                if (this.transaction_table[15] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(string);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(38 + this.transaction_table[15], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDBitmap(Bitmap bitmap, InnerLcdCallback callback) throws RemoteException {
                if (this.transaction_table[16] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        _data.writeInt(1);
                        bitmap.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(39 + this.transaction_table[16], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPrinterMode() throws RemoteException {
                int _result;
                if (this.transaction_table[17] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(40 + this.transaction_table[17], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPrinterBBMDistance() throws RemoteException {
                int _result;
                if (this.transaction_table[18] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(41 + this.transaction_table[18], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void printBitmapCustom(Bitmap bitmap, int type, InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[20] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        _data.writeInt(1);
                        bitmap.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(type);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(42 + this.transaction_table[20], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getForcedDouble() throws RemoteException {
                int _result;
                if (this.transaction_table[21] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(43 + this.transaction_table[21], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isForcedAntiWhite() throws RemoteException {
                boolean _result;
                if (this.transaction_table[22] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(44 + this.transaction_table[22], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isForcedBold() throws RemoteException {
                boolean _result;
                if (this.transaction_table[23] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(45 + this.transaction_table[23], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isForcedUnderline() throws RemoteException {
                boolean _result;
                if (this.transaction_table[24] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(46 + this.transaction_table[24], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getForcedRowHeight() throws RemoteException {
                int _result;
                if (this.transaction_table[25] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(47 + this.transaction_table[25], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFontName() throws RemoteException {
                int _result;
                if (this.transaction_table[26] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(48 + this.transaction_table[26], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDDoubleString(String topText, String bottomText, InnerLcdCallback callback) throws RemoteException {
                if (this.transaction_table[27] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(topText);
                    _data.writeString(bottomText);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(49 + this.transaction_table[27], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPrinterPaper() throws RemoteException {
                int _result;
                if (this.transaction_table[28] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(50 + this.transaction_table[28], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getDrawerStatus() throws RemoteException {
                boolean _result;
                if (this.transaction_table[29] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(51 + this.transaction_table[29], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDFillString(String string, int size, boolean fill, InnerLcdCallback callback) throws RemoteException {
                if (this.transaction_table[30] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(string);
                    _data.writeInt(size);
                    _data.writeInt(fill ? 1 : 0);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(52 + this.transaction_table[30], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendLCDMultiString(String[] text, int[] align, InnerLcdCallback callback) throws RemoteException {
                if (this.transaction_table[31] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(text);
                    _data.writeIntArray(align);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(53 + this.transaction_table[31], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPrinterDensity() throws RemoteException {
                int _result;
                if (this.transaction_table[32] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(54 + this.transaction_table[32], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void print2DCode(String data, int symbology, int modulesize, int errorlevel, InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[33] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(data);
                    _data.writeInt(symbology);
                    _data.writeInt(modulesize);
                    _data.writeInt(errorlevel);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(55 + this.transaction_table[33], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void autoOutPaper(InnerResultCallback callback) throws RemoteException {
                if (this.transaction_table[34] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean res = this.mRemote.transact(56 + this.transaction_table[34], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrinterStyle(int key, int value) throws RemoteException {
                if (this.transaction_table[35] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    _data.writeInt(value);
                    boolean res = this.mRemote.transact(57 + this.transaction_table[35], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void labelLocate() throws RemoteException {
                if (this.transaction_table[36] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(58 + this.transaction_table[36], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void labelOutput() throws RemoteException {
                if (this.transaction_table[37] == 9527) {
                    throw new InnerPrinterException("this model does not support this method!");
                }
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean res = this.mRemote.transact(59 + this.transaction_table[37], _data, _reply, 0);
                    if (!res) {
                        throw new InnerPrinterException("this version does not support this method!");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

