/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;

class SharedPreferencesUtil {
    public static final String PREFERENCE_FILE_NAME = "obj_cache";
    private static Gson gson = new Gson();

    SharedPreferencesUtil() {
    }

    public static Object readObj(Context context, String key, Type type) {
        Object obj = null;
        SharedPreferences pre = context.getSharedPreferences(PREFERENCE_FILE_NAME, 0);
        String json = pre.getString(key, "");
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object o = gson.fromJson(json, type);
        return o;
    }

    public static <T> T readObj(Context context, String key, Class<T> clazz) {
        Object obj = null;
        SharedPreferences pre = context.getSharedPreferences(PREFERENCE_FILE_NAME, 0);
        String json = pre.getString(key, "");
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object t = gson.fromJson(json, clazz);
        return (T)t;
    }

    public static <T> void saveObj(Context context, T obj, String key) {
        SharedPreferences spf = context.getSharedPreferences(PREFERENCE_FILE_NAME, 0);
        String json = gson.toJson(obj);
        SharedPreferences.Editor editor = spf.edit();
        editor.putString(key, json);
        editor.apply();
    }

    public static void clearByKey(String key, Context context) {
        SharedPreferences spf = context.getSharedPreferences(PREFERENCE_FILE_NAME, 0);
        SharedPreferences.Editor editor = spf.edit();
        editor.putString(key, "");
        editor.apply();
    }
}

