/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.greenrobot.greendao.database.Database;
import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;
import sunmi.ds.gen.DSFileDao;
import sunmi.ds.gen.DSFilesDao;
import sunmi.ds.gen.DaoMaster;
import sunmi.ds.gen.DaoSession;

public class FilesManager {
    private static final String DS_FILE_LIST = "DSFileList";
    private static final String DS_FILES_LIST = "DSFilesList";
    private DaoSession daoSession;
    private DSFileDao fileDao;
    private DSFilesDao filesDao;
    private Map<Long, DSFile> receFileList = new HashMap<Long, DSFile>();
    private Map<Long, DSFiles> receFilesList = new HashMap<Long, DSFiles>();
    private static FilesManager instance;

    private FilesManager() {
    }

    public static FilesManager getInstance() {
        if (instance == null) {
            instance = new FilesManager();
        }
        return instance;
    }

    public void init(Context context) {
        if (null == this.daoSession) {
            DaoMaster.DevOpenHelper helper = new DaoMaster.DevOpenHelper(context, "sunmidslib-db");
            Database db = helper.getWritableDb();
            this.daoSession = new DaoMaster(db).newSession();
            this.fileDao = this.daoSession.getDSFileDao();
            this.filesDao = this.daoSession.getDSFilesDao();
        }
        List dsfile = this.fileDao.queryBuilder().list();
        for (DSFile file : dsfile) {
            Log.d((String)"Sunmi", (String)("dsfile: ---------->" + file.getPath()));
            this.receFileList.put(file.getTaskId(), file);
        }
        List dsFiles = this.filesDao.queryBuilder().list();
        for (DSFiles files : dsFiles) {
            Log.d((String)"Sunmi", (String)("dsFiles: ---------->" + files.getTaskId() + "  " + files.getFiles().size()));
            this.receFilesList.put(files.getTaskId(), files);
        }
    }

    public synchronized void saveFile(DSFile dsFile) {
        this.receFileList.put(dsFile.taskId, dsFile);
        if (null != this.fileDao) {
            this.fileDao.save(dsFile);
        }
    }

    public synchronized DSFile getFile(Long taskId) {
        return this.receFileList.get(taskId);
    }

    public synchronized void saveFiles(DSFiles dsFiles) {
        this.receFilesList.put(dsFiles.taskId, dsFiles);
        if (null != dsFiles) {
            this.filesDao.save(dsFiles);
        }
    }

    public synchronized DSFiles getFiles(Long taskId) {
        return this.receFilesList.get(taskId);
    }

    public boolean checkFileExist(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) {
            File file1 = new File(file.path);
            if (file1.exists()) {
                Log.d((String)"Sunmi", (String)(file.path + "\u6587\u4ef6\u5b58\u5728"));
                return true;
            }
            Log.d((String)"Sunmi", (String)(file.path + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
            return false;
        }
        if (files != null) {
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); ++i) {
                File file1 = new File(filePaths.get((int)i).path);
                if (!file1.exists()) {
                    Log.d((String)"Sunmi", (String)("\u591a\u6587\u4ef6\u4e2d" + filePaths.get((int)i).path + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
                    return false;
                }
                Log.d((String)"Sunmi", (String)("\u591a\u6587\u4ef6\u4e2d" + filePaths.get((int)i).path + "\u6587\u4ef6\u5b58\u5728"));
            }
            return true;
        }
        Log.d((String)"Sunmi", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728"));
        return false;
    }

    public boolean deleteFile(long fileId) {
        FilesManager filesManager = FilesManager.getInstance();
        DSFile file = filesManager.getFile(fileId);
        DSFiles files = filesManager.getFiles(fileId);
        if (file != null) {
            File file1 = new File(file.path);
            if (!file1.exists()) {
                Log.d((String)"Sunmi", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c"));
                return true;
            }
            Log.d((String)"Sunmi", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u5b58\u5728,\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
            if (file1.delete()) {
                if (null != this.fileDao) {
                    this.fileDao.delete(file);
                }
                return true;
            }
            return false;
        }
        if (files != null) {
            List<DSFile> filePaths = files.files;
            for (int i = 0; i < filePaths.size(); ++i) {
                File file1 = new File(filePaths.get((int)i).path);
                if (file1.exists()) {
                    Log.d((String)"Sunmi", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u5b58\u5728,\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
                    if (file1.delete()) continue;
                    return false;
                }
                Log.d((String)"Sunmi", (String)(fileId + "\u591a\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c" + file1.getAbsolutePath()));
            }
            if (null != this.filesDao) {
                this.filesDao.delete(files);
            }
            return true;
        }
        Log.d((String)"Sunmi", (String)(fileId + "\u6587\u4ef6\u5728\u5e94\u7528\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728,\u4e0d\u9700\u8981\u505a\u5220\u9664\u64cd\u4f5c"));
        return true;
    }
}

