/*
 * Decompiled with CFR 0.152.
 */
package sunmi.ds;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sunmi.ds.DSKernel;
import sunmi.ds.FilesManager;
import sunmi.ds.callback.IConnectionCallback;
import sunmi.ds.callback.IReceiveCallback;
import sunmi.ds.callback.QueryCallback;
import sunmi.ds.data.DSData;
import sunmi.ds.data.DSFile;
import sunmi.ds.data.DSFiles;
import sunmi.ds.data.FilesDescribe;

public class DSReceiver {
    private static final String TAG = "DSReceiver";
    private Context context;
    private String sender;
    private DSKernel dsKernel;
    private FilesManager filesManager;
    private List<IReceiveCallback> receiveCallbackList = new ArrayList<IReceiveCallback>();
    private Map<Long, QueryCallback> queryCallbackMap = new HashMap<Long, QueryCallback>();
    private Map<Long, DSFiles> multiFileTaskList = new HashMap<Long, DSFiles>();
    private static DSReceiver mDSReceiver;

    private DSReceiver() {
    }

    private DSReceiver(Context context) {
        this.context = context;
        this.filesManager = FilesManager.getInstance();
        this.filesManager.init(context);
    }

    public static DSReceiver getInstance(Context context) {
        if (mDSReceiver == null) {
            mDSReceiver = new DSReceiver(context);
        }
        return mDSReceiver;
    }

    public void setDSKernel(DSKernel dsKernel) {
        this.dsKernel = dsKernel;
    }

    public void addQueryCallback(long queryId, QueryCallback callback) {
        this.queryCallbackMap.put(queryId, callback);
    }

    public void addReceiveCallback(IReceiveCallback callback) {
        if (!this.receiveCallbackList.contains(callback)) {
            this.receiveCallbackList.add(callback);
        }
    }

    public void removeReceiveCallback(IReceiveCallback callback) {
        this.receiveCallbackList.remove(callback);
    }

    public void onReceive(Intent intent) {
        Log.d((String)TAG, (String)"onReceive:\u6536\u5230\u5e7f\u64ad\u6570\u636e");
        if (intent.hasExtra("sender")) {
            this.sender = intent.getStringExtra("sender");
        }
        if (intent.hasExtra("data")) {
            this.processData(intent.getByteArrayExtra("data"));
        } else {
            this.processFile(intent);
        }
    }

    private void processData(byte[] data) {
        if (this.dsKernel == null) {
            return;
        }
        try {
            Bundle bundle = new Bundle();
            Intent i = new Intent();
            String jsonString = new String(data, "utf-8");
            DSData dsData = (DSData)JSON.parseObject((String)jsonString, DSData.class);
            dsData.sender = this.sender;
            switch (dsData.dataType) {
                case CHECK_FILE: {
                    Log.d((String)"highsixty", (String)("CHECK_FILE: ------------>" + dsData.data));
                    boolean exist = false;
                    long fileId = dsData.fileId;
                    exist = !TextUtils.isEmpty((CharSequence)dsData.data) && dsData.data.equals("delete") ? this.filesManager.deleteFile(fileId) : this.filesManager.checkFileExist(fileId);
                    this.dsKernel.sendResult(dsData.sender, exist + "", dsData.taskId, null);
                    break;
                }
                case PRE_FILES: {
                    FilesDescribe fd = (FilesDescribe)JSON.parseObject((String)dsData.data, FilesDescribe.class);
                    DSFiles dsFiles = new DSFiles();
                    dsFiles.filesDescribe = fd;
                    dsFiles.taskId = dsData.taskId;
                    this.multiFileTaskList.put(dsData.taskId, dsFiles);
                    break;
                }
                case FILE: {
                    break;
                }
                case DATA: {
                    this.dataCallback(dsData);
                    break;
                }
                case CMD: {
                    this.cmdCallback(dsData);
                    break;
                }
                case CHECK_CONN: {
                    this.dsKernel.sendConnOK(this.sender);
                    break;
                }
                case OK_CONN: {
                    this.dsKernel.onConnStateChange(IConnectionCallback.ConnState.VICE_APP_CONN);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void processFile(Intent intent) {
        String path = "";
        long userFlag = -1L;
        if (intent.hasExtra("path")) {
            path = intent.getStringExtra("path");
        }
        if (intent.hasExtra("userFlag")) {
            userFlag = intent.getLongExtra("userFlag", -1L);
        }
        DSFile file = new DSFile();
        file.sender = this.sender;
        file.path = path;
        file.taskId = userFlag;
        DSFiles dsFiles = this.multiFileTaskList.get(userFlag);
        if (dsFiles == null) {
            this.fileCallback(file);
        } else {
            dsFiles.addFile(file);
            FilesDescribe fd = dsFiles.filesDescribe;
            if (fd.fileCount == dsFiles.files.size()) {
                dsFiles.sender = file.sender;
                this.fileCallback(dsFiles);
                this.multiFileTaskList.remove(dsFiles.taskId);
            }
        }
    }

    public void onConnectStateChange(Intent intent) {
        if (this.dsKernel == null) {
            return;
        }
        boolean isConn = intent.getBooleanExtra("connect_state", false);
        if (isConn) {
            this.dsKernel.onConnStateChange(IConnectionCallback.ConnState.VICE_SERVICE_CONN);
        } else {
            this.dsKernel.onConnStateChange(IConnectionCallback.ConnState.DIS_CONN);
        }
    }

    void fileCallback(DSFile file) {
        this.filesManager.saveFile(file);
        if (!this.receiveCallbackList.isEmpty()) {
            for (IReceiveCallback callback : this.receiveCallbackList) {
                callback.onReceiveFile(file);
            }
        }
    }

    void fileCallback(DSFiles files) {
        this.filesManager.saveFiles(files);
        if (!this.receiveCallbackList.isEmpty()) {
            for (IReceiveCallback callback : this.receiveCallbackList) {
                callback.onReceiveFiles(files);
            }
        }
    }

    void cmdCallback(DSData dataPack) {
        if (!this.receiveCallbackList.isEmpty()) {
            for (IReceiveCallback callback : this.receiveCallbackList) {
                callback.onReceiveCMD(dataPack);
            }
        }
    }

    void dataCallback(DSData dataPack) {
        QueryCallback queryCallback = this.queryCallbackMap.get(dataPack.queryId);
        if (queryCallback != null) {
            queryCallback.onReceiveData(dataPack);
            this.queryCallbackMap.remove(dataPack.queryId);
            return;
        }
        if (!this.receiveCallbackList.isEmpty()) {
            for (IReceiveCallback callback : this.receiveCallbackList) {
                callback.onReceiveData(dataPack);
            }
        }
    }
}

