/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xhandler;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xhandler.StringCompare;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import sun.net.www.MessageHeader;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sun.net.www.URLConnection;

public class NfsURLConnection
extends URLConnection {
    InputStream is = null;
    XFileInputStream nis = null;
    XFile nfsFile = null;
    boolean isConnected = false;

    NfsURLConnection(URL u) {
        super(u);
    }

    @Override
    public void connect() throws IOException {
        String host = this.url.getHost();
        try {
            InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new IOException("Unknown Host");
        }
        if (this.isConnected) {
            return;
        }
        try {
            this.nfsFile = new XFile(this.url.toString());
        }
        catch (Exception e) {
            throw new IOException("Unable to open xfile");
        }
        this.isConnected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        boolean root_directory = false;
        if (!this.isConnected) {
            this.connect();
        }
        if (!this.nfsFile.exists()) {
            throw new IOException("Cannot Access File " + this.nfsFile.getPath() + "!");
        }
        if (!this.nfsFile.canRead()) {
            throw new IOException("Read Access Not Allowed for " + this.nfsFile.getPath());
        }
        String path = this.url.getFile();
        if (path.equals("/")) {
            path = "/.";
            root_directory = true;
        } else if (path.charAt(0) == '/') {
            path = path.substring(1, path.length());
        }
        MessageHeader props = new MessageHeader();
        MimeTable mt = MimeTable.getDefaultTable();
        if (this.nfsFile.isDirectory()) {
            String[] dirList;
            StringBuffer buf = new StringBuffer();
            int iconHeight = Integer.getInteger("hotjava.file.iconheight", 32);
            int iconWidth = Integer.getInteger("hotjava.file.iconwidth", 32);
            props.add("content-type", "text/html");
            this.setProperties(props);
            buf.append("<HTML>\n<HEAD>\n<TITLE>");
            buf.append(System.getProperty("file.dir.title", "Directory Listing"));
            buf.append("</TITLE>\n");
            buf.append("<BASE HREF=\"" + this.url.toString());
            if (this.url.toString().endsWith("/")) {
                buf.append("\">");
            } else {
                buf.append("/\">");
            }
            buf.append("</HEAD>\n<BODY>\n");
            if (root_directory) {
                buf.append("<H1>\n/</H1>\n<HR>\n");
            } else {
                buf.append("<H1>\n" + path + "</H1>\n<HR>\n");
            }
            if (!root_directory) {
                String parentURL = this.url.toString();
                int limit = parentURL.length() - 1;
                if (this.url.getFile() != null) {
                    if (parentURL.endsWith("/")) {
                        --limit;
                    }
                    parentURL = parentURL.substring(0, parentURL.lastIndexOf(47, limit));
                    buf.append("<A HREF=\"" + parentURL + "\">");
                    buf.append("<H2>Go To Parent Directory</H2></A>\n<BR>\n");
                }
            }
            if ((dirList = this.nfsFile.list()) != null) {
                StringCompare strComp = new StringCompare();
                Arrays.sort(dirList, strComp);
                boolean hideDotFiles = Boolean.getBoolean("file.hidedotfiles");
                for (int i = 0; i < dirList.length; ++i) {
                    if (dirList[i].equals("..") || dirList[i].equals(".") || hideDotFiles && dirList[i].charAt(0) == '.') continue;
                    buf.append("<IMG ALIGN=middle SRC=\"");
                    XFile dirEntry = new XFile(this.nfsFile, dirList[i]);
                    String MimeEntry_defaultImagePath = "";
                    if (dirEntry.isDirectory()) {
                        buf.append(MimeEntry_defaultImagePath + "/directory.gif\" WIDTH=" + iconWidth + " HEIGHT=" + iconHeight + ">\n");
                    } else if (dirEntry.isFile()) {
                        String realImageName;
                        String imageFileName = MimeEntry_defaultImagePath + "/file.gif";
                        MimeEntry entry = mt.findByFileName(dirList[i]);
                        if (entry != null && (realImageName = entry.getImageFileName()) != null) {
                            imageFileName = realImageName;
                        }
                        buf.append(imageFileName);
                        buf.append("\" WIDTH=" + iconWidth + " HEIGHT=" + iconHeight + ">\n");
                    } else {
                        buf.append(MimeEntry_defaultImagePath + "/file.gif\" WIDTH=" + iconWidth + " HEIGHT=" + iconHeight + ">\n");
                    }
                    buf.append("<A HREF=\"" + dirList[i] + "\">");
                    buf.append(dirList[i] + "</A>\n<BR>");
                }
            }
            buf.append("</BODY>\n</HTML>\n");
            this.is = new ByteArrayInputStream(buf.toString().getBytes());
        } else {
            MimeEntry entry = mt.findByFileName(path);
            if (entry != null) {
                props.add("content-type", entry.getType());
            }
            this.setProperties(props);
            if (!this.nfsFile.exists()) {
                throw new IOException("Cannot Access File " + this.nfsFile.getPath() + "!");
            }
            this.is = new XFileInputStream(this.nfsFile);
            if (this.is == null) {
                throw new IOException("Unable to Open InputStream for " + this.url.getFile());
            }
        }
        return this.is;
    }
}

