/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class XRandomAccessFile
implements DataOutput,
DataInput {
    private long fp;
    private boolean readOnly;
    private XFileAccessor xfa;

    public XRandomAccessFile(XFile xf, String mode) throws IOException {
        if (!mode.equals("r") && !mode.equals("rw")) {
            throw new IllegalArgumentException("mode must be r or rw");
        }
        this.readOnly = mode.equals("r");
        this.xfa = xf.newAccessor();
        this.xfa.open(xf, false, this.readOnly);
        if (this.xfa.exists()) {
            if (this.readOnly && !this.xfa.canRead()) {
                throw new IOException("no read permission");
            }
            if (!this.readOnly && !this.xfa.canWrite()) {
                throw new IOException("no write permission");
            }
        } else {
            if (this.readOnly) {
                throw new IOException("no such file or directory");
            }
            if (!this.xfa.mkfile()) {
                throw new IOException("no write permission");
            }
        }
    }

    public XRandomAccessFile(String name, String mode) throws IOException {
        this(new XFile(name), mode);
    }

    private int XFAread(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        int c = this.xfa.read(b, off, len, this.fp);
        if (c >= 0) {
            this.fp += (long)c;
        }
        return c;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.XFAread(b, 0, 1) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.XFAread(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.XFAread(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (this.XFAread(b, off, len) < len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.fp + (long)n > this.xfa.length()) {
            throw new EOFException();
        }
        this.seek(this.fp + (long)n);
        return n;
    }

    private void XFAwrite(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.readOnly) {
            throw new IOException("Read only file");
        }
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.xfa.write(b, off, len, this.fp);
        this.fp += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.XFAwrite(new byte[]{(byte)b}, 0, 1);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        this.XFAwrite(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this.fp;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L || this.readOnly && pos >= this.xfa.length()) {
            throw new IOException("illegal seek" + pos);
        }
        this.fp = pos;
    }

    public long length() throws IOException {
        return this.xfa.length();
    }

    public void flush() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only file");
        }
        this.xfa.flush();
    }

    public void close() throws IOException {
        this.xfa.close();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }
}

