/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc.samples;

import com.sun.rpc.CredGss;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InputStream;

class RPCGSSClient {
    private static final int ADDRLISTPROG = 0x25000000;
    private static final int ADDRLISTVERS = 1;
    private static final int ADDR_SET = 1;
    private static final int ADDR_GET = 2;
    private static final int ADDR_DEL = 3;
    private static final int SVC_SET = 4;
    private static final int CREATE = 5;
    private static final int DESTROY = 6;
    private static final int LOOP = 8;
    private static final int QUIT = 7;
    private static final String mech1 = "1.2.840.113554.1.2.2";
    private static final String mech2 = "1.3.6.1.4.1.42.2.26.1.2";
    private static String serverHost;
    private static String serviceName;
    private static String mech;
    private static String svcString;
    private static int op;
    private static int serviceType;
    private static int loop_times;
    private static String name;
    private static String addr;

    RPCGSSClient() {
    }

    public static void main(String[] args) {
        Rpc rpc = null;
        CredGss cred = null;
        Xdr callmsg = new Xdr(1024);
        if (args.length < 2 || args.length > 4) {
            RPCGSSClient.usage();
            RPCGSSClient.exit(1);
        }
        serverHost = args[0];
        serviceName = args[1];
        if (args.length > 2) {
            if (args[2].equals("-m")) {
                if (args[3].equals("1")) {
                    mech = mech1;
                    RPCGSSClient.print("Kerberos mechanism " + mech);
                } else if (args[3].equals("2")) {
                    mech = mech2;
                    RPCGSSClient.print("Dummy mechanism " + mech);
                } else {
                    RPCGSSClient.usage();
                    RPCGSSClient.exit(1);
                }
            } else {
                RPCGSSClient.usage();
                RPCGSSClient.exit(1);
            }
        } else {
            mech = mech2;
            RPCGSSClient.print("Dummy mechanism " + mech);
        }
        try {
            rpc = new Rpc(serverHost, 0, 0x25000000, 1, "tcp", 512);
        }
        catch (IOException e) {
            RPCGSSClient.print("\n***RPC ERROR:\t" + e.toString());
            e.printStackTrace();
            RPCGSSClient.exit(-1);
        }
        while (true) {
            try {
                block15: while (true) {
                    RPCGSSClient.parseargs();
                    switch (op) {
                        case 5: {
                            cred = new CredGss(serviceName, mech, serviceType, 0);
                            rpc.setCred(cred);
                            break;
                        }
                        case 4: {
                            if (svcString.equals("none")) {
                                serviceType = 1;
                            } else if (svcString.equals("integrity")) {
                                serviceType = 2;
                            } else if (svcString.equals("privacy")) {
                                serviceType = 3;
                            }
                            if (cred == null) break;
                            cred.serviceType = serviceType;
                            break;
                        }
                        case 1: {
                            rpc.rpc_header(callmsg, 1);
                            callmsg.xdr_string(name);
                            callmsg.xdr_string(addr);
                            Xdr replymsg = rpc.rpc_call(callmsg, 3000, 3);
                            boolean status = replymsg.xdr_bool();
                            if (status) {
                                RPCGSSClient.print("set ok \n");
                                break;
                            }
                            RPCGSSClient.print("set failed\n");
                            break;
                        }
                        case 2: {
                            rpc.rpc_header(callmsg, 2);
                            callmsg.xdr_string(name);
                            Xdr replymsg = rpc.rpc_call(callmsg, 3000, 3);
                            name = replymsg.xdr_string();
                            addr = replymsg.xdr_string();
                            if (addr.getBytes().length != 0) {
                                RPCGSSClient.print(name + " = " + addr);
                                break;
                            }
                            RPCGSSClient.print("no value");
                            break;
                        }
                        case 3: {
                            rpc.rpc_header(callmsg, 3);
                            callmsg.xdr_string(name);
                            Xdr replymsg = rpc.rpc_call(callmsg, 3000, 3);
                            boolean status = replymsg.xdr_bool();
                            if (status) {
                                RPCGSSClient.print("delete ok");
                                break;
                            }
                            RPCGSSClient.print("delete failed");
                            break;
                        }
                        case 6: {
                            if (cred != null) {
                                rpc.delCred();
                                RPCGSSClient.print("Context destroyed");
                                cred = null;
                                break;
                            }
                            RPCGSSClient.print("No Context to be destroyed");
                            break;
                        }
                        case 8: {
                            if (cred != null) {
                                rpc.delCred();
                                cred = null;
                            }
                            int i = 0;
                            while (loop_times-- > 0) {
                                RPCGSSClient.print("\n***LOOP " + ++i + "***");
                                cred = new CredGss(serviceName, mech, serviceType, 0);
                                rpc.setCred(cred);
                                rpc.delCred();
                                cred = null;
                                RPCGSSClient.print("Context destroyed");
                            }
                            continue block15;
                        }
                        case 7: {
                            RPCGSSClient.exit(0);
                        }
                    }
                }
            }
            catch (IOException e) {
                RPCGSSClient.print("\n**IO ERRORS**:\t" + e.toString());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void parseargs() {
        InputStream in = System.in;
        byte[] argbuf = new byte[128];
        String[] args = new String[4];
        RPCGSSClient.usage1();
        System.out.print("enter cmd -> ");
        try {
            int len = in.read(argbuf);
            int offset = 0;
            int n = 0;
            int i = 0;
            while (i < len - 1) {
                while (Character.isSpace((char)argbuf[i])) {
                    ++i;
                }
                offset = i;
                while ((char)argbuf[i] != '\n' && (char)argbuf[i] != ' ') {
                    ++i;
                }
                args[n++] = new String(argbuf, 0, offset, i - offset);
            }
            args[n] = null;
        }
        catch (IOException e) {
            RPCGSSClient.print(e.toString());
            RPCGSSClient.parseargs();
        }
        if (args[0] == null) {
            RPCGSSClient.parseargs();
        }
        if (args[0].equals("set")) {
            op = 1;
            name = args[1];
            addr = args[2];
            if (name == null || addr == null) {
                RPCGSSClient.print("syntax error");
                RPCGSSClient.parseargs();
            }
        } else if (args[0].equals("get")) {
            op = 2;
            name = args[1];
            if (name == null) {
                RPCGSSClient.print("syntax error");
                RPCGSSClient.parseargs();
            }
        } else if (args[0].equals("del")) {
            op = 3;
            if (args[1] == null) {
                RPCGSSClient.print("syntax error");
                RPCGSSClient.parseargs();
            }
            name = args[1];
        } else if (args[0].equals("service")) {
            op = 4;
            if (args[1] == null) {
                RPCGSSClient.print("syntax error");
                RPCGSSClient.parseargs();
            }
            svcString = args[1];
        } else if (args[0].equals("create-context")) {
            op = 5;
        } else if (args[0].equals("destroy-context")) {
            op = 6;
        } else if (args[0].equals("loop")) {
            op = 8;
            loop_times = args[1] != null ? Integer.parseInt(args[1]) : 5;
        } else if (args[0].equals("quit") || args[0].equals("exit")) {
            op = 7;
        } else {
            RPCGSSClient.print("syntax error");
            RPCGSSClient.parseargs();
        }
    }

    private static void usage1() {
        RPCGSSClient.print("\ncommands are:");
        RPCGSSClient.print("\tset <name> <value>");
        RPCGSSClient.print("\tget <name>");
        RPCGSSClient.print("\tdel <name>");
        RPCGSSClient.print("\tservice (integrity | privacy | none)");
        RPCGSSClient.print("\tcreate-context");
        RPCGSSClient.print("\tdestroy-context");
        RPCGSSClient.print("\tloop n");
        RPCGSSClient.print("\tquit");
    }

    private static void usage() {
        RPCGSSClient.print("\nUsage: ");
        RPCGSSClient.print("\tjava RPCGSSClient serverHost serviceName -m mech#\n");
        RPCGSSClient.print("\t-m 1 is for kerberos_v5");
        RPCGSSClient.print("\t-m 2 is for dummy");
        RPCGSSClient.print("\tdefault mech is dummy if -m is not specified\n");
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    private static void exit(int status) {
        System.exit(status);
    }

    static {
        op = 0;
        serviceType = 3;
        name = null;
        addr = null;
    }
}

