/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

public class Xdr {
    private static int XDRUNIT = 4;
    private byte[] buf;
    private int size;
    private int off;
    private int wrap_offset;
    int xid;

    public Xdr(int size) {
        this.buf = new byte[size];
        this.size = size;
        this.off = 0;
    }

    public void xdr_skip(int count) {
        int r = (this.off += count) % XDRUNIT;
        if (r > 0) {
            this.off += XDRUNIT - r;
        }
    }

    public byte[] xdr_buf() {
        return this.buf;
    }

    public int xdr_offset() {
        return this.off;
    }

    public void xdr_offset(int off) {
        this.off = off;
    }

    public int xdr_wrap_offset() {
        return this.wrap_offset;
    }

    public void xdr_wrap_offset(int off) {
        this.wrap_offset = off;
    }

    public int xdr_size() {
        return this.size;
    }

    public void xdr_size(int size) {
        this.size = size;
    }

    public int xdr_int() {
        return (this.buf[this.off++] & 0xFF) << 24 | (this.buf[this.off++] & 0xFF) << 16 | (this.buf[this.off++] & 0xFF) << 8 | this.buf[this.off++] & 0xFF;
    }

    public void xdr_int(int i) {
        this.buf[this.off++] = (byte)(i >>> 24);
        this.buf[this.off++] = (byte)(i >> 16);
        this.buf[this.off++] = (byte)(i >> 8);
        this.buf[this.off++] = (byte)i;
    }

    public long xdr_u_int() {
        return (this.buf[this.off++] & 0xFF) << 24 | (this.buf[this.off++] & 0xFF) << 16 | (this.buf[this.off++] & 0xFF) << 8 | this.buf[this.off++] & 0xFF;
    }

    public void xdr_u_int(long i) {
        this.buf[this.off++] = (byte)(i >>> 24 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 16);
        this.buf[this.off++] = (byte)(i >> 8);
        this.buf[this.off++] = (byte)i;
    }

    public long xdr_hyper() {
        return (long)(this.buf[this.off++] & 0xFF) << 56 | (long)(this.buf[this.off++] & 0xFF) << 48 | (long)(this.buf[this.off++] & 0xFF) << 40 | (long)(this.buf[this.off++] & 0xFF) << 32 | (long)(this.buf[this.off++] & 0xFF) << 24 | (long)(this.buf[this.off++] & 0xFF) << 16 | (long)(this.buf[this.off++] & 0xFF) << 8 | (long)(this.buf[this.off++] & 0xFF);
    }

    public void xdr_hyper(long i) {
        this.buf[this.off++] = (byte)(i >>> 56);
        this.buf[this.off++] = (byte)(i >> 48 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 40 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 32 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 24 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 16 & 0xFFL);
        this.buf[this.off++] = (byte)(i >> 8 & 0xFFL);
        this.buf[this.off++] = (byte)(i & 0xFFL);
    }

    public boolean xdr_bool() {
        return this.xdr_int() != 0;
    }

    public void xdr_bool(boolean b) {
        this.xdr_int(b ? 1 : 0);
    }

    public float xdr_float() {
        return Float.intBitsToFloat(this.xdr_int());
    }

    public void xdr_float(float f) {
        this.xdr_int(Float.floatToIntBits(f));
    }

    public String xdr_string() {
        int len = this.xdr_int();
        String s = new String(this.buf, this.off, len);
        this.xdr_skip(len);
        return s;
    }

    public void xdr_string(String s) {
        this.xdr_bytes(s.getBytes());
    }

    public byte[] xdr_bytes() {
        return this.xdr_raw(this.xdr_int());
    }

    public void xdr_bytes(byte[] b) {
        this.xdr_bytes(b, 0, b.length);
    }

    public void xdr_bytes(byte[] b, int len) {
        this.xdr_bytes(b, 0, len);
    }

    public void xdr_bytes(byte[] b, int boff, int len) {
        this.xdr_int(len);
        System.arraycopy(b, boff, this.buf, this.off, len);
        this.xdr_skip(len);
    }

    public void xdr_bytes(Xdr x) {
        this.xdr_bytes(x.xdr_buf(), x.xdr_offset());
    }

    public byte[] xdr_raw(int len) {
        if (len == 0) {
            return null;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buf, this.off, b, 0, len);
        this.xdr_skip(len);
        return b;
    }

    public byte[] xdr_raw(int off, int len) {
        if (len == 0) {
            return null;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.buf, off, b, 0, len);
        return b;
    }

    public void xdr_raw(byte[] b) {
        int len = b.length;
        System.arraycopy(b, 0, this.buf, this.off, len);
        this.xdr_skip(len);
    }

    public void xdr_raw(byte[] b, int off) {
        int len = b.length;
        System.arraycopy(b, 0, this.buf, off, len);
        this.xdr_skip(len);
    }

    public void xdr_raw(byte[] b, int boff, int len) {
        System.arraycopy(b, boff, this.buf, this.off, len);
        this.xdr_skip(len);
    }
}

