/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.ConnectDatagram;
import com.sun.rpc.ConnectSocket;
import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.CredNone;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.RpcException;
import com.sun.rpc.RpcHandler;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Hashtable;

public class Rpc {
    public Connection conn;
    int prog;
    int vers;
    Cred cred;
    RpcHandler rhandler = new RpcHandler();
    private static int xid = (int)System.currentTimeMillis() & 0xFFFFFFF;
    private static final int PMAP_PROG = 100000;
    private static final int PMAP_PORT = 111;
    private static final int PMAP_VERS = 2;
    private static final int PMAP_GETPORT = 3;
    private static final int PMAP_MAXSZ = 128;
    private static final int MAX_TIMEOUT = 30000;
    private static final int MAX_REPLY = 8448;
    static final int CALL = 0;
    static final int REPLY = 1;
    static final int MSG_ACCEPTED = 0;
    static final int MSG_DENIED = 1;
    static final int SUCCESS = 0;
    static final int PROG_UNAVAIL = 1;
    static final int PROG_MISMATCH = 2;
    static final int PROC_UNAVAIL = 3;
    static final int GARBAGE_ARGS = 4;
    static final int SYSTEM_ERR = 5;
    static final int RPC_MISMATCH = 0;
    static final int AUTH_ERROR = 1;

    public Rpc(Connection conn, int prog, int vers) {
        this.conn = conn;
        this.prog = prog;
        this.vers = vers;
        this.cred = new CredNone();
    }

    public Rpc(Connection conn, int prog, int vers, Cred cr) {
        this.conn = conn;
        this.prog = prog;
        this.vers = vers;
        this.cred = cr;
    }

    public Rpc(String server, int port, int prog, int vers, String proto, int maxReply) throws IOException {
        this.conn = this.getConnection(server, port, prog, vers, proto, maxReply);
        this.prog = prog;
        this.vers = vers;
        this.cred = new CredNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(String server, int port, int prog, int vers, String proto, int maxReply) throws IOException {
        if (port == 0) {
            Rpc pmap = new Rpc(server, 111, 100000, 2, "udp", 128);
            Xdr call = new Xdr(128);
            pmap.rpc_header(call, 3);
            call.xdr_int(prog);
            call.xdr_int(vers);
            call.xdr_int(proto.equals("tcp") ? 6 : 17);
            call.xdr_int(0);
            Xdr reply = pmap.rpc_call(call, 5000, 3);
            port = reply.xdr_int();
            if (port == 0) {
                throw new MsgAcceptedException(1);
            }
        }
        Hashtable hashtable = Connection.connections;
        synchronized (hashtable) {
            this.conn = Connection.getCache(server, port, proto);
            if (this.conn == null) {
                this.conn = proto.equals("tcp") ? new ConnectSocket(server, port, maxReply) : new ConnectDatagram(server, port, maxReply);
                Connection.putCache(this.conn);
            }
        }
        return this.conn;
    }

    public void setCred(Cred c) throws RpcException {
        this.cred = c;
        this.cred.init(this.conn, this.prog, this.vers);
    }

    public void delCred() throws RpcException {
        this.cred.destroy(this);
    }

    public Cred getCred() {
        return this.cred;
    }

    public void setRpcHandler(RpcHandler r) {
        this.rhandler = r == null ? new RpcHandler() : r;
    }

    public void rpc_header(Xdr call, int proc) throws RpcException {
        call.xid = Rpc.next_xid();
        call.xdr_offset(this.conn instanceof ConnectSocket ? 4 : 0);
        call.xdr_int(call.xid);
        call.xdr_int(0);
        call.xdr_int(2);
        call.xdr_int(this.prog);
        call.xdr_int(this.vers);
        call.xdr_int(proc);
        this.cred.putCred(call);
    }

    static synchronized int next_xid() {
        return xid++;
    }

    private Xdr call_reconstruct(Xdr call, byte[] arg) throws IOException, RpcException {
        Xdr recall = new Xdr(call.xdr_size());
        recall.xid = call.xid;
        recall.xdr_raw(call.xdr_raw(0, this.conn instanceof ConnectSocket ? 28 : 24));
        this.cred.putCred(recall);
        if (arg != null) {
            if (recall.xdr_offset() == recall.xdr_wrap_offset()) {
                recall.xdr_raw(arg);
            } else {
                recall.xdr_raw(arg, 4, arg.length - 4);
            }
        }
        return recall;
    }

    public Xdr rpc_call_one(Xdr call, byte[] arg, int timeout) throws IOException, RpcException {
        Xdr reply;
        if (arg != null) {
            this.cred.wrap(call, arg);
        }
        if ((reply = this.conn.send(call, timeout)).xdr_int() != 1) {
            throw new RpcException("Unknown RPC header");
        }
        int status = reply.xdr_int();
        block0 : switch (status) {
            case 0: {
                reply.xdr_skip(4);
                byte[] verifier = reply.xdr_bytes();
                int astat = reply.xdr_int();
                switch (astat) {
                    case 0: {
                        int seq_num_in = this.cred.unwrap(reply);
                        if (seq_num_in <= 0) break block0;
                        this.cred.validate(verifier, seq_num_in);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new MsgAcceptedException(astat, reply.xdr_int(), reply.xdr_int());
                    }
                }
                throw new MsgAcceptedException(astat);
            }
            case 1: {
                int rstat = reply.xdr_int();
                switch (rstat) {
                    case 0: {
                        throw new MsgRejectedException(rstat, reply.xdr_int(), reply.xdr_int());
                    }
                    case 1: {
                        int why = reply.xdr_int();
                        throw new MsgRejectedException(rstat, why);
                    }
                }
                throw new MsgRejectedException(rstat);
            }
        }
        return reply;
    }

    public Xdr rpc_call(Xdr call, int timeout, int retries) throws IOException {
        boolean timedout = false;
        Xdr reply = null;
        long startTime = System.currentTimeMillis();
        if (retries == 0) {
            retries = Integer.MAX_VALUE;
        }
        if (this.conn instanceof ConnectSocket) {
            timeout = 30000;
        }
        int num_refresh = 2;
        for (int c = 0; c < retries; ++c) {
            byte[] arg = null;
            if (!(this.cred instanceof CredUnix) && !(this.cred instanceof CredNone) && call.xdr_offset() > call.xdr_wrap_offset()) {
                arg = call.xdr_raw(call.xdr_wrap_offset(), call.xdr_offset() - call.xdr_wrap_offset());
            }
            try {
                reply = this.rpc_call_one(call, arg, timeout);
                break;
            }
            catch (MsgRejectedException e) {
                if (num_refresh > 0 && (e.why == 13 || e.why == 14) && this.cred.refresh(this.conn, this.prog, this.vers)) {
                    call = this.call_reconstruct(call, arg);
                    --num_refresh;
                    --c;
                    continue;
                }
                throw e;
            }
            catch (RpcException e) {
                throw e;
            }
            catch (IOException e) {
                if (this.rhandler.timeout(this.conn.server, c, (int)(System.currentTimeMillis() - startTime))) {
                    throw new InterruptedIOException();
                }
                timedout = true;
                if ((timeout *= 2) > 30000) {
                    timeout = 30000;
                }
                if (this.cred instanceof CredUnix || this.cred instanceof CredNone) continue;
                call = this.call_reconstruct(call, arg);
            }
        }
        if (reply == null) {
            throw new InterruptedIOException();
        }
        if (timedout && reply != null) {
            this.rhandler.ok(this.conn.server);
        }
        return reply;
    }

    public InetAddress getPeer() {
        return this.conn.getPeer();
    }
}

