/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.RpcException;

public class MsgRejectedException
extends RpcException {
    public static final int RPC_MISMATCH = 0;
    public static final int AUTH_ERROR = 1;
    public static final int AUTH_BADCRED = 1;
    public static final int AUTH_REJECTEDCRED = 2;
    public static final int AUTH_BADVERF = 3;
    public static final int AUTH_REJECTEDVERF = 4;
    public static final int AUTH_TOOWEAK = 5;
    public static final int AUTH_INVALIDRESP = 6;
    public static final int AUTH_FAILED = 7;
    public static final int RPCSEC_GSS_NOCRED = 13;
    public static final int RPCSEC_GSS_FAILED = 14;

    public MsgRejectedException(int error) {
        super(error);
    }

    public MsgRejectedException(int error, int why) {
        super(error);
        this.why = why;
    }

    public MsgRejectedException(int error, int lo, int hi) {
        super(error);
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public String toString() {
        switch (this.error) {
            case 0: {
                return "Version mismatch: low=" + this.lo + ",high=" + this.hi;
            }
            case 1: {
                String msg = "Authentication error: ";
                switch (this.why) {
                    case 1: {
                        msg = msg + "bogus credentials (seal broken)";
                        break;
                    }
                    case 2: {
                        msg = msg + "client should begin new session";
                        break;
                    }
                    case 3: {
                        msg = msg + "bogus verifier (seal broken)";
                        break;
                    }
                    case 4: {
                        msg = msg + "verifier expired or was replayed";
                        break;
                    }
                    case 5: {
                        msg = msg + "too weak";
                        break;
                    }
                    case 6: {
                        msg = msg + "bogus response verifier";
                        break;
                    }
                    case 13: {
                        msg = msg + "no credentials for user";
                        break;
                    }
                    case 14: {
                        msg = msg + "GSS failure, credentials deleted";
                        break;
                    }
                    default: {
                        msg = msg + "unknown reason";
                    }
                }
                return msg;
            }
        }
        return "Unknown RPC Error = " + this.error;
    }
}

