/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.gssapi.GSSContext;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.RpcException;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;

public class CredGss
extends Cred {
    public int serviceType;
    Oid mechOid;
    int qop;
    String serviceName;
    int seq_num_out;
    int seq_window;
    int control;
    GSSContext gssCtx;
    byte[] ctx_handle;
    public static final int RPCSEC_GSS = 6;
    public static final int RPCSEC_GSS_DATA = 0;
    public static final int RPCSEC_GSS_INIT = 1;
    public static final int RPCSEC_GSS_CONTINUE_INIT = 2;
    public static final int RPCSEC_GSS_DESTROY = 3;
    public static final int RPCSEC_GSS_VERS_1 = 1;
    private static final int RPCGSS_MAXSZ = 1024;
    private static final int PROC_NULL = 0;

    public CredGss(String svcName, String mech, int svcType, int qop_num) throws IOException {
        try {
            this.mechOid = new Oid(mech);
        }
        catch (GSSException e) {
            throw new IOException("can not construct CredGss object");
        }
        this.serviceName = svcName;
        this.serviceType = svcType;
        this.qop = qop_num;
        this.seq_num_out = 0;
        this.ctx_handle = null;
        this.gssCtx = null;
        this.control = 1;
    }

    public CredGss(String svcName, Oid mech, int svcType, int qop_num) {
        this.mechOid = mech;
        this.serviceName = svcName;
        this.serviceType = svcType;
        this.qop = qop_num;
        this.seq_num_out = 0;
        this.ctx_handle = null;
        this.gssCtx = null;
        this.control = 1;
    }

    @Override
    synchronized void putCred(Xdr x) throws RpcException {
        MessageProp mInfo = new MessageProp(this.qop, false);
        x.xdr_int(6);
        if (this.control == 0 || this.control == 3) {
            ++this.seq_num_out;
        }
        if (this.ctx_handle != null) {
            x.xdr_int(20 + this.ctx_handle.length);
            x.xdr_int(1);
            x.xdr_int(this.control);
            x.xdr_int(this.seq_num_out);
            x.xdr_int(this.serviceType);
            x.xdr_bytes(this.ctx_handle);
        } else {
            x.xdr_int(20);
            x.xdr_int(1);
            x.xdr_int(this.control);
            x.xdr_int(this.seq_num_out);
            x.xdr_int(this.serviceType);
            x.xdr_int(0);
        }
        if (this.gssCtx != null) {
            try {
                byte[] headerMIC = this.gssCtx.getMIC(x.xdr_buf(), 0, x.xdr_offset(), mInfo);
                x.xdr_int(6);
                x.xdr_bytes(headerMIC);
            }
            catch (GSSException e) {
                throw new RpcException("can not checksum the header");
            }
        } else {
            x.xdr_int(0);
            x.xdr_int(0);
        }
        x.xdr_wrap_offset(x.xdr_offset());
        if (this.control == 0 && this.serviceType != 1) {
            x.xdr_int(this.seq_num_out);
        }
    }

    @Override
    public void getCred(Xdr x) {
    }

    private Xdr rpc_send(Rpc rpc, Xdr call, int timeout, int retries) throws RpcException, IOException {
        Xdr reply = null;
        if (retries == 0) {
            retries = Integer.MAX_VALUE;
        }
        for (int c = 0; c < retries; ++c) {
            try {
                reply = rpc.rpc_call_one(call, null, timeout);
                break;
            }
            catch (RpcException e) {
                throw e;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (reply == null) {
            throw new InterruptedIOException();
        }
        return reply;
    }

    @Override
    synchronized void init(Connection conn, int prog, int vers) throws RpcException {
        byte[] inTok = new byte[]{};
        int major = 0;
        int minor = 0;
        try {
            GSSContext ctx = new GSSContext(new GSSName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE), this.mechOid, null, 0);
            ctx.requestConf(true);
            ctx.requestInteg(true);
            ctx.requestMutualAuth(true);
            ctx.requestReplayDet(true);
            ctx.requestSequenceDet(true);
            CredGss initCred = new CredGss(this.serviceName, this.mechOid, this.serviceType, this.qop);
            Rpc secRpc = new Rpc(conn, prog, vers, initCred);
            Xdr secCall = new Xdr(1024);
            initCred.control = 1;
            int num_refresh = 2;
            do {
                byte[] outTok;
                if ((outTok = ctx.init(inTok, 0, inTok.length)) != null) {
                    Xdr secReply;
                    secRpc.rpc_header(secCall, 0);
                    secCall.xdr_bytes(outTok);
                    try {
                        secReply = this.rpc_send(secRpc, secCall, 30000, 5);
                    }
                    catch (MsgRejectedException e) {
                        if (num_refresh > 0 && (e.why == 13 || e.why == 14)) {
                            inTok = new byte[]{};
                            ctx = new GSSContext(new GSSName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE), this.mechOid, null, 0);
                            ctx.requestConf(true);
                            ctx.requestInteg(true);
                            ctx.requestMutualAuth(true);
                            ctx.requestReplayDet(true);
                            ctx.requestSequenceDet(true);
                            initCred.gssCtx = null;
                            initCred.ctx_handle = null;
                            initCred.control = 1;
                            --num_refresh;
                            continue;
                        }
                        throw e;
                    }
                    catch (RpcException e) {
                        throw e;
                    }
                    this.ctx_handle = secReply.xdr_bytes();
                    major = secReply.xdr_int();
                    minor = secReply.xdr_int();
                    if (major != 0 && major != 1) {
                        throw new RpcException("cred.init server failed");
                    }
                    this.seq_window = secReply.xdr_int();
                    inTok = secReply.xdr_bytes();
                    if (!ctx.isEstablished() && inTok == null) {
                        throw new RpcException("cred.init:bad token");
                    }
                } else if (major == 1) {
                    throw new RpcException("cred.init:server needs token");
                }
                initCred.control = 2;
                initCred.ctx_handle = this.ctx_handle;
            } while (!ctx.isEstablished());
            this.gssCtx = ctx;
            this.control = 0;
        }
        catch (IOException e) {
            throw new RpcException("cred.init: io errors ");
        }
        catch (GSSException e) {
            throw new RpcException("cred.init: gss errors");
        }
    }

    @Override
    synchronized boolean refresh(Connection conn, int prog, int vers) {
        if (this.ctx_handle == null) {
            return false;
        }
        this.gssCtx = null;
        this.ctx_handle = null;
        try {
            this.init(conn, prog, vers);
            return true;
        }
        catch (RpcException e) {
            return false;
        }
    }

    @Override
    synchronized void wrap(Xdr call, byte[] arg) throws RpcException {
        MessageProp mInfo = new MessageProp(this.qop, false);
        if (this.control != 0) {
            return;
        }
        try {
            switch (this.serviceType) {
                case 1: {
                    break;
                }
                case 2: {
                    byte[] argTok = this.gssCtx.getMIC(arg, 0, arg.length, mInfo);
                    call.xdr_offset(call.xdr_wrap_offset());
                    call.xdr_bytes(arg);
                    call.xdr_bytes(argTok);
                    break;
                }
                case 3: {
                    mInfo.setPrivacy(true);
                    byte[] argTok = this.gssCtx.wrap(arg, 0, arg.length, mInfo);
                    call.xdr_offset(call.xdr_wrap_offset());
                    call.xdr_bytes(argTok);
                }
            }
        }
        catch (GSSException e) {
            throw new RpcException("wrap: Can not wrap RPC arg");
        }
    }

    @Override
    synchronized int unwrap(Xdr reply) throws RpcException {
        int seq_num_in = 0;
        MessageProp mInfo = new MessageProp();
        if (this.control != 0) {
            return 0;
        }
        int result_off = reply.xdr_offset();
        switch (this.serviceType) {
            case 1: {
                return 0;
            }
            case 2: {
                int result_len = reply.xdr_int();
                if (result_len <= 4) {
                    return 0;
                }
                int verify_off = reply.xdr_offset();
                seq_num_in = reply.xdr_int();
                if (seq_num_in < this.seq_num_out - this.seq_window || seq_num_in > this.seq_num_out) {
                    throw new RpcException("unwrap: bad sequence number");
                }
                byte[] result = reply.xdr_raw(result_len - 4);
                int csum_len = reply.xdr_int();
                try {
                    this.gssCtx.verifyMIC(reply.xdr_buf(), reply.xdr_offset(), csum_len, reply.xdr_buf(), verify_off, result_len, mInfo);
                }
                catch (GSSException e) {
                    throw new RpcException("unwrap: gss_verifyMIC failed");
                }
                if (mInfo.getQOP() != this.qop) {
                    throw new RpcException("unwrap: unexpected qop");
                }
                reply.xdr_offset(result_off);
                reply.xdr_raw(result);
                reply.xdr_offset(result_off);
                break;
            }
            case 3: {
                byte[] result;
                int result_len = reply.xdr_int();
                if (result_len == 0) {
                    return 0;
                }
                try {
                    result = this.gssCtx.unwrap(reply.xdr_buf(), reply.xdr_offset(), result_len, mInfo);
                }
                catch (GSSException e) {
                    throw new RpcException("unwrap: gss_unwrap failed");
                }
                if (mInfo.getQOP() != this.qop) {
                    throw new RpcException("unwrap: unexpected qop");
                }
                reply.xdr_offset(result_off);
                reply.xdr_raw(result);
                reply.xdr_offset(result_off);
                seq_num_in = reply.xdr_int();
                if (seq_num_in >= this.seq_num_out - this.seq_window && seq_num_in <= this.seq_num_out) break;
                throw new RpcException("unwrap: bad sequence number");
            }
        }
        return seq_num_in;
    }

    @Override
    synchronized void validate(byte[] token, int snumber) throws RpcException {
        if (this.control != 0) {
            return;
        }
        MessageProp mInfo = new MessageProp();
        byte[] msg = new byte[]{(byte)(snumber >>> 24), (byte)(snumber >> 16), (byte)(snumber >> 8), (byte)snumber};
        try {
            this.gssCtx.verifyMIC(token, 0, token.length, msg, 0, msg.length, mInfo);
        }
        catch (GSSException e) {
            throw new RpcException("CredGss: validate failed");
        }
    }

    @Override
    synchronized void destroy(Rpc rpc) throws RpcException {
        if (this.gssCtx != null) {
            try {
                Xdr secCall = new Xdr(1024);
                this.control = 3;
                rpc.rpc_header(secCall, 0);
                rpc.rpc_call(secCall, 30000, 5);
                this.gssCtx.dispose();
                this.mechOid = null;
                this.gssCtx = null;
                this.ctx_handle = null;
            }
            catch (IOException secCall) {
            }
            catch (GSSException e) {
                return;
            }
        }
    }
}

