/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Mount;
import com.sun.nfs.NfsConnect;
import com.sun.nfs.NfsHandler;
import com.sun.nfs.NfsURL;
import com.sun.xfile.XFile;
import java.io.IOException;
import java.net.UnknownHostException;

public class XFileExtensionAccessor
extends com.sun.xfile.XFileExtensionAccessor {
    XFile xf;

    public XFileExtensionAccessor(XFile xf) {
        super(xf);
        if (!xf.getFileSystemName().equals("nfs")) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.xf = xf;
    }

    public boolean loginPCNFSD(String host, String username, String password) {
        return NfsConnect.getCred().fetchCred(host, username, password);
    }

    public void logoutPCNFSD() {
        NfsConnect.getCred().setCred();
    }

    public void loginUGID(int uid, int gid, int[] gids) {
        NfsConnect.getCred().setCred(uid, gid, gids);
    }

    public void logoutUGID() {
        NfsConnect.getCred().setCred();
    }

    public void setNfsHandler(NfsHandler handler) {
        NfsConnect.setRpcHandler(handler);
    }

    public String[] getExports() throws UnknownHostException, IOException {
        new Mount();
        return Mount.getExports(new NfsURL(this.xf.toString()).getHost());
    }
}

