/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.xfile.XFile;
import java.io.IOException;

public class XFileAccessor
implements com.sun.xfile.XFileAccessor {
    XFile xf;
    boolean serial;
    boolean readOnly;
    Nfs nfs;

    @Override
    public boolean open(XFile xf, boolean serial, boolean readOnly) {
        this.xf = xf;
        try {
            this.nfs = NfsConnect.connect(xf.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public XFile getXFile() {
        return this.xf;
    }

    protected Nfs getParent(XFile xf) throws IOException {
        XFile xfp = new XFile(xf.getParent());
        XFileAccessor nfsx = new XFileAccessor();
        nfsx.open(xfp, this.serial, this.readOnly);
        return nfsx.getNfs();
    }

    protected Nfs getNfs() {
        return this.nfs;
    }

    @Override
    public boolean exists() {
        try {
            return this.nfs.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return this.nfs.canWrite();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.nfs.canRead();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.nfs.isFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.nfs.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.nfs.mtime();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return this.nfs.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean mkfile() {
        try {
            this.nfs = this.getParent(this.xf).create(this.xf.getName(), 438L);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            this.nfs = this.getParent(this.xf).mkdir(this.xf.getName(), 511L);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean renameTo(XFile dest) {
        try {
            Nfs sParent = this.getParent(this.xf);
            Nfs dParent = this.getParent(dest);
            return sParent.rename(dParent, this.xf.getName(), dest.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String[] list() {
        try {
            return this.nfs.readdir();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean delete() {
        try {
            boolean ok = this.isFile() ? this.getParent(this.xf).remove(this.xf.getName()) : this.getParent(this.xf).rmdir(this.xf.getName());
            if (ok) {
                this.nfs.invalidate();
                this.nfs = null;
            }
            return ok;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int read(byte[] b, int off, int len, long foff) throws IOException {
        int c = this.nfs.read(b, off, len, foff);
        return c;
    }

    @Override
    public void write(byte[] b, int off, int len, long foff) throws IOException {
        this.nfs.write(b, off, len, foff);
    }

    @Override
    public void flush() throws IOException {
        this.nfs.flush();
    }

    @Override
    public void close() throws IOException {
        this.nfs.close();
    }

    public String toString() {
        return this.nfs.toString();
    }
}

