/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.net.MalformedURLException;

public class NfsURL {
    private String url;
    private String protocol;
    private String host;
    private String location;
    private int port;
    private String file;
    private int version;
    private String proto;
    private boolean pub = true;

    public NfsURL(String url) throws MalformedURLException {
        int q;
        this.url = url = url.trim();
        int end = url.length();
        int p = url.indexOf(58);
        if (p < 0) {
            throw new MalformedURLException("colon expected");
        }
        this.protocol = url.substring(0, p);
        if (url.regionMatches(++p, "//", 0, 2)) {
            q = url.indexOf(47, p += 2);
            if (q < 0) {
                q = end;
            }
            this.location = url.substring(0, q);
            int r = url.indexOf(58, p);
            if (r > 0 && r < q) {
                byte[] opts = url.substring(r + 1, q).toLowerCase().getBytes();
                block7: for (int i = 0; i < opts.length; ++i) {
                    if (opts[i] >= 48 && opts[i] <= 57) {
                        this.port = this.port * 10 + (opts[i] - 48);
                        continue;
                    }
                    switch (opts[i]) {
                        case 118: {
                            this.version = opts[++i] - 48;
                            continue block7;
                        }
                        case 116: {
                            this.proto = "tcp";
                            continue block7;
                        }
                        case 117: {
                            this.proto = "udp";
                            continue block7;
                        }
                        case 119: {
                            this.pub = true;
                            continue block7;
                        }
                        case 109: {
                            this.pub = false;
                            continue block7;
                        }
                        default: {
                            throw new MalformedURLException("invalid port number");
                        }
                    }
                }
            } else {
                r = q;
            }
            if (p < r) {
                this.host = url.substring(p, r);
            }
        } else {
            q = p;
        }
        if (q < end) {
            this.file = url.substring(q + 1, end);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getFile() {
        return this.file;
    }

    int getVersion() {
        return this.version;
    }

    String getProto() {
        return this.proto;
    }

    boolean getPub() {
        return this.pub;
    }

    public String toString() {
        String s = this.getProtocol() + ":";
        if (this.host != null) {
            s = s + "//" + this.host;
        }
        if (this.port > 0) {
            s = s + ":" + this.port;
        }
        if (this.file != null) {
            s = s + "/" + this.file;
        }
        return s;
    }
}

