/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Fattr;
import com.sun.rpc.Xdr;
import java.util.Date;

class Fattr3
extends Fattr {
    int ftype;
    long mode;
    long nlink;
    long uid;
    long gid;
    long size;
    long used;
    long rdev;
    long fsid;
    long fileid;
    long atime;
    long mtime;
    long ctime;

    Fattr3() {
    }

    Fattr3(Xdr x) {
        this.getFattr(x);
    }

    @Override
    void putFattr(Xdr x) {
        x.xdr_int(this.ftype);
        x.xdr_u_int(this.mode);
        x.xdr_u_int(this.nlink);
        x.xdr_u_int(this.uid);
        x.xdr_u_int(this.gid);
        x.xdr_hyper(this.size);
        x.xdr_hyper(this.used);
        x.xdr_hyper(this.rdev);
        x.xdr_hyper(this.fsid);
        x.xdr_hyper(this.fileid);
        x.xdr_u_int(this.atime / 1000L);
        x.xdr_u_int(this.atime % 1000L * 1000000L);
        x.xdr_u_int(this.mtime / 1000L);
        x.xdr_u_int(this.mtime % 1000L * 1000000L);
        x.xdr_u_int(this.ctime / 1000L);
        x.xdr_u_int(this.ctime % 1000L * 1000000L);
    }

    @Override
    void getFattr(Xdr x) {
        long oldmtime = this.mtime;
        this.ftype = x.xdr_int();
        this.mode = x.xdr_u_int();
        this.nlink = x.xdr_u_int();
        this.uid = x.xdr_u_int();
        if (this.uid == -2L) {
            this.uid = 60001L;
        }
        this.gid = x.xdr_u_int();
        if (this.gid == -2L) {
            this.gid = 60001L;
        }
        this.size = x.xdr_hyper();
        this.used = x.xdr_hyper();
        this.rdev = x.xdr_hyper();
        this.fsid = x.xdr_hyper();
        this.fileid = x.xdr_hyper();
        this.atime = x.xdr_u_int() * 1000L + x.xdr_u_int() / 1000000L;
        this.mtime = x.xdr_u_int() * 1000L + x.xdr_u_int() / 1000000L;
        this.ctime = x.xdr_u_int() * 1000L + x.xdr_u_int() / 1000000L;
        long delta = this.mtime - oldmtime;
        if (delta > 0L) {
            this.cachetime = delta;
            if (this.cachetime < 3000L) {
                this.cachetime = 3000L;
            } else if (this.cachetime > 60000L) {
                this.cachetime = 60000L;
            }
        }
        this.validtime = System.currentTimeMillis();
    }

    public String toString() {
        return " ftype = " + this.ftype + "\n" + "  mode = 0" + Long.toOctalString(this.mode) + "\n" + " nlink = " + this.nlink + "\n" + "   uid = " + this.uid + "\n" + "   gid = " + this.gid + "\n" + "  size = " + this.size + "\n" + "  used = " + this.used + "\n" + "  rdev = 0x" + Long.toHexString(this.rdev) + "\n" + "  fsid = " + this.fsid + "\n" + "fileid = " + this.fileid + "\n" + " atime = " + new Date(this.atime) + "\n" + " mtime = " + new Date(this.mtime) + "\n" + " ctime = " + new Date(this.ctime);
    }
}

