/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi.samples;

import com.sun.gssapi.GSSContext;
import com.sun.gssapi.GSSCredential;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

class GSSServer {
    private static ServerSocket s;

    GSSServer() {
    }

    public static void main(String[] args) {
        int port = 4444;
        if (args.length < 1) {
            GSSServer.usage();
            GSSServer.exit(-1);
        }
        try {
            String serviceName = args[args.length - 1];
            Oid mechOid = GSSManager.getDefaultMech();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-port")) {
                    if (i >= args.length - 2) {
                        GSSServer.usage();
                        GSSServer.exit(-1);
                    }
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (!args[i].equals("-mech")) continue;
                if (i >= args.length - 2) {
                    GSSServer.usage();
                    GSSServer.exit(-1);
                }
                mechOid = new Oid(args[++i]);
            }
            GSSServer.print("\nAcquiring credentials as " + serviceName + "...");
            GSSCredential server = new GSSCredential(new GSSName(serviceName, GSSName.NT_HOSTBASED_SERVICE), Integer.MAX_VALUE, mechOid, 2);
            GSSServer.print("\nDumping credential info...\n" + server.toString() + "\n");
            s = new ServerSocket(port);
            while (true) {
                GSSServer.print("\n\nWaiting for connections on port " + port + "...");
                Socket c = s.accept();
                GSSServer.print("Accepted connection from " + c.getInetAddress().getHostName());
                GSSServer.processClient(server, c);
            }
        }
        catch (IOException e) {
            GSSServer.print("\n**Communication ERROR**:\t" + e.getMessage());
            e.printStackTrace();
            GSSServer.exit(-1);
        }
        catch (GSSException e) {
            GSSServer.print("\n**GSSAPI ERROR**:\t" + e.getMessage());
            e.printStackTrace();
            GSSServer.exit(-1);
        }
    }

    private static void processClient(GSSCredential server, Socket client) throws GSSException, IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(client.getInputStream()));
        DataOutputStream dos = new DataOutputStream(client.getOutputStream());
        GSSServer.print("\n\nCreating context...");
        int tokLen = dis.readInt();
        GSSServer.print("\tReceiving token from peer (" + tokLen + " bytes)...");
        GSSContext aCtxt = new GSSContext(server);
        byte[] inTok = new byte[tokLen];
        dis.readFully(inTok, 0, inTok.length);
        while (true) {
            byte[] outTok;
            if ((outTok = aCtxt.accept(inTok, 0, inTok.length)) != null) {
                GSSServer.print("\tSending token to peer...");
                dos.writeInt(outTok.length);
                dos.write(outTok);
            }
            if (aCtxt.isEstablished()) break;
            inTok = new byte[dis.readInt()];
            GSSServer.print("\tReceiving token from peer (" + inTok.length + " bytes)...");
            dis.readFully(inTok, 0, inTok.length);
        }
        GSSServer.print("\tContext is fully established");
        GSSServer.displayContext(aCtxt);
        GSSServer.exchangeWithPeer(aCtxt, dis, dos);
        aCtxt.dispose();
        client.close();
    }

    private static void displayContext(GSSContext aCtxt) throws GSSException {
        GSSServer.print("\n\nContext Information....");
        if (aCtxt.getLifetime() == Integer.MAX_VALUE) {
            GSSServer.print("\tOver mech:\t" + aCtxt.getMech().toString() + " for  " + " INDEFINITE seconds");
        } else {
            GSSServer.print("\tOver mech:\t" + aCtxt.getMech().toString() + " for  " + aCtxt.getLifetime() + " seconds");
        }
        GSSServer.print("\tInitiator:\t" + aCtxt.getSrcName().toString());
        GSSServer.print("\tAcceptor:\t" + aCtxt.getTargName().toString());
        if (aCtxt.getDelegCredState()) {
            GSSServer.print("\tDelegated credentials available.");
        } else {
            GSSServer.print("\tNO delegated credentials");
        }
        if (aCtxt.getMutualAuthState()) {
            GSSServer.print("\tMutaul Authentication ON");
        } else {
            GSSServer.print("\tNO mutual authentication performed.");
        }
        if (aCtxt.getReplayDetState()) {
            GSSServer.print("\tReplay detraction ON");
        } else {
            GSSServer.print("\tNO replay detection");
        }
        if (aCtxt.getSequenceDetState()) {
            GSSServer.print("\tSequence detection ON");
        } else {
            GSSServer.print("\tNO sequence detection");
        }
        if (aCtxt.getAnonymityState()) {
            GSSServer.print("\tAnonymous context");
        }
        if (aCtxt.isTransferable()) {
            GSSServer.print("\tContext is transferable");
        } else {
            GSSServer.print("\tNO context transfer");
        }
        if (aCtxt.isProtReady()) {
            GSSServer.print("\tContext protection is ready");
        } else {
            GSSServer.print("**ERROR wrong state - context established, but isProtReady = false");
        }
        if (aCtxt.getConfState()) {
            GSSServer.print("\tConfidentiality available");
        } else {
            GSSServer.print("\tNO confidentiality services");
        }
        if (aCtxt.getIntegState()) {
            GSSServer.print("\tIntegrity available");
        } else {
            GSSServer.print("\tNO integrity services");
        }
    }

    private static void exchangeWithPeer(GSSContext aCtxt, DataInputStream dis, DataOutputStream dos) throws GSSException, IOException {
        GSSServer.print("\n\nPeer message exchange...");
        int len = dis.readInt();
        GSSServer.print("\tReceiving message from peer (" + len + " bytes)....");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MessageProp mInfo = new MessageProp();
        aCtxt.unwrap(dis, bos, mInfo);
        GSSServer.print("\tMessage from peer:\t" + new String(bos.toByteArray()));
        mInfo.setQOP(0);
        mInfo.setPrivacy(false);
        GSSServer.print("\n\tSending MIC to peer.");
        byte[] peerTok = bos.toByteArray();
        byte[] toPeer = aCtxt.getMIC(peerTok, 0, peerTok.length, mInfo);
        dos.writeInt(toPeer.length);
        dos.write(toPeer);
        dos.close();
    }

    private static void usage() {
        GSSServer.print("\nUsage:\tGSSServert [-mech 1.2.34] [-port port] serviceName");
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    private static void exit(int status) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(status);
    }
}

