/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.MechInfo;
import com.sun.gssapi.MechTable;
import com.sun.gssapi.Oid;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class GSSManager {
    private static MechInfo m_defaultMech;

    private static void initialize() {
        int i = 1;
        try {
            String name;
            ResourceBundle props = ResourceBundle.getBundle("com.sun.gssapi.mechs");
            while ((name = props.getString("gss.provider." + i++)) != null) {
                Class<?> cl = Class.forName(name);
                Object instance = cl.newInstance();
                if (!(instance instanceof Provider)) continue;
                Security.addProvider((Provider)instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Oid[] getMechs() {
        Provider[] p = Security.getProviders();
        Vector aV = new Vector(5, 3);
        for (int i = 0; i < p.length; ++i) {
            String[] mechs = MechInfo.getMechsForProvider(p[i]);
            if (mechs == null) continue;
            for (int j = 0; j < mechs.length; ++j) {
                try {
                    GSSManager.addUniqueOid(aV, new Oid(mechs[j]));
                    continue;
                }
                catch (GSSException gSSException) {
                    // empty catch block
                }
            }
        }
        if (aV.size() == 0) {
            return null;
        }
        Object[] mechs = new Oid[aV.size()];
        aV.copyInto(mechs);
        return mechs;
    }

    public static Oid[] getNamesForMech(Oid mech) throws GSSException {
        MechInfo aMech = GSSManager.getMechInfo(mech, false);
        return aMech.getNames();
    }

    public static Oid[] getMechsForName(Oid nameType) {
        Provider[] p = Security.getProviders();
        Vector v = new Vector(5, 3);
        for (int i = 0; i < p.length; ++i) {
            MechInfo[] mechs = MechInfo.getInfoForAllMechs(p[i]);
            if (mechs == null) continue;
            for (int j = 0; j < mechs.length; ++j) {
                if (!mechs[j].supportsName(nameType)) continue;
                GSSManager.addUniqueOid(v, mechs[j].getOid());
            }
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] oids = new Oid[v.size()];
        v.copyInto(oids);
        return oids;
    }

    public static Oid getDefaultMech() throws GSSException {
        if (m_defaultMech != null) {
            return m_defaultMech.getOid();
        }
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String[] mechs = MechInfo.getMechsForProvider(p[i]);
            if (mechs == null) continue;
            m_defaultMech = new MechInfo(p[i], mechs[0]);
            return m_defaultMech.getOid();
        }
        throw new GSSException(2);
    }

    private static void addUniqueOid(Vector v, Oid anOid) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            if (!((Oid)e.nextElement()).equals(anOid)) continue;
            return;
        }
        v.addElement(anOid);
    }

    static GSSCredSpi getCredInstance(Oid mech) throws GSSException {
        MechInfo aMech = GSSManager.getMechInfo(mech, true);
        return aMech.getCredInstance();
    }

    static GSSNameSpi getNameInstance(Oid mech) throws GSSException {
        MechInfo aMech = GSSManager.getMechInfo(mech, true);
        return aMech.getNameInstance();
    }

    static C018FE95 _M4092FBA(Oid mech) throws GSSException {
        MechInfo aMech = GSSManager.getMechInfo(mech, true);
        return aMech._M4092FBA();
    }

    private static synchronized MechInfo getMechInfo(Oid oid, boolean installMech) throws GSSException {
        MechInfo aMech = MechTable.getMechInfo(oid);
        if (aMech != null) {
            if (installMech) {
                MechTable.putMechInfo(aMech);
            }
            return aMech;
        }
        Provider[] p = Security.getProviders();
        String mechString = oid.toString();
        for (int i = 0; i < p.length; ++i) {
            if (!MechInfo.implementsMech(p[i], mechString)) continue;
            try {
                aMech = new MechInfo(p[i], mechString);
                if (installMech) {
                    MechTable.putMechInfo(aMech);
                }
                return aMech;
            }
            catch (GSSException e) {
                // empty catch block
            }
        }
        throw new GSSException(2);
    }

    private static void showProviderDetails() {
        Provider[] p = Security.getProviders();
        boolean foundGSSProv = false;
        for (int i = 0; i < p.length; ++i) {
            MechInfo[] mechs = MechInfo.getInfoForAllMechs(p[i]);
            if (mechs == null) continue;
            foundGSSProv = true;
        }
    }

    static {
        GSSManager.initialize();
    }
}

