/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

public class GSSException
extends Exception {
    public static final int BAD_BINDINGS = 1;
    public static final int BAD_MECH = 2;
    public static final int BAD_NAME = 3;
    public static final int BAD_NAMETYPE = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int CONTEXT_EXPIRED = 7;
    public static final int CREDENTIALS_EXPIRED = 8;
    public static final int DEFECTIVE_CREDENTIAL = 9;
    public static final int DEFECTIVE_TOKEN = 10;
    public static final int FAILURE = 11;
    public static final int NO_CONTEXT = 12;
    public static final int NO_CRED = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 19;
    public static final int OLD_TOKEN = 20;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    private static String[] messages = new String[]{"channel binding mismatch", "unsupported mechanism requested", "invalid name provided", "name of unsupported type provided", "invalid input status selector", "token had invalid integrity check", "specified security context expired", "expired credentials detected", "defective credential detected", "defective token detected", "failure, unspecified at GSS-API level", "security context init/accept not yet called or context deleted", "no valid credentials provided", "unsupported QOP value", "operation unauthorized", "operation unavailable", "duplicate credential element requested", "name contains multi-mechanism elements", "the token was a duplicate of an earlier token", "the token's validity period has expired", "a later token has already been processed", "an expected per-message token was not received"};
    private int m_major;
    private int m_minor = 0;
    private String m_minorMessage = null;

    public GSSException(int majorCode) {
        this.m_major = this.validateMajor(majorCode) ? majorCode : 5;
    }

    public GSSException(int majorCode, int minorCode, String minorString) {
        this.m_major = this.validateMajor(majorCode) ? majorCode : 5;
        this.m_minor = minorCode;
        this.m_minorMessage = minorString;
    }

    public int getMajor() {
        return this.m_major;
    }

    public int getMinor() {
        return this.m_minor;
    }

    public String getMajorString() {
        return messages[this.m_major - 1];
    }

    public String getMinorString() {
        if (this.m_minorMessage == null) {
            this.m_minorMessage = "";
        }
        return this.m_minorMessage;
    }

    public void setMinor(int minorCode, String message) {
        this.m_minor = minorCode;
        this.m_minorMessage = message;
    }

    @Override
    public String toString() {
        if (this.m_minor == 0) {
            return this.getMajorString();
        }
        return this.getMajorString() + "(" + this.getMinorString() + ")";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    private boolean validateMajor(int major) {
        return this.m_major > 0 && this.m_major <= messages.length;
    }
}

