/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.Oid;
import java.util.Enumeration;
import java.util.Vector;

public class GSSCredential {
    public static final int INITIATE_AND_ACCEPT = 0;
    public static final int INITIATE_ONLY = 1;
    public static final int ACCEPT_ONLY = 2;
    public static final int INDEFINITE = Integer.MAX_VALUE;
    Vector m_mechCreds = new Vector(3, 3);

    public GSSCredential(int usage) throws GSSException {
        this.add(null, Integer.MAX_VALUE, Integer.MAX_VALUE, null, usage);
    }

    public GSSCredential(GSSName aName, int usage) throws GSSException {
        this.add(aName, Integer.MAX_VALUE, Integer.MAX_VALUE, null, usage);
    }

    public GSSCredential(GSSName aName, int lifetime, Oid mechOid, int usage) throws GSSException {
        this.add(aName, lifetime, lifetime, mechOid, usage);
    }

    public GSSCredential(GSSName aName, int lifetime, Oid[] mechs, int usage) throws GSSException {
        for (int i = 0; i < mechs.length; ++i) {
            this.add(aName, lifetime, lifetime, mechs[i], usage);
        }
    }

    GSSCredential(GSSCredSpi mechCred) {
        this.m_mechCreds.addElement(mechCred);
    }

    public void dispose() throws GSSException {
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            ((GSSCredSpi)e.nextElement()).dispose();
        }
        this.m_mechCreds.removeAllElements();
    }

    public GSSName getGSSName() throws GSSException {
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        GSSName aName = new GSSName();
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            aName.addMechName(((GSSCredSpi)e.nextElement()).getName());
        }
        return aName;
    }

    public GSSName getGSSName(Oid mechOID) throws GSSException {
        GSSName aName = new GSSName();
        aName.addMechName(this.getMechCred(mechOID, true).getName());
        return aName;
    }

    public int getRemainingLifetime() throws GSSException {
        int lifetime = Integer.MAX_VALUE;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            GSSCredSpi aCred = (GSSCredSpi)e.nextElement();
            if (aCred.getLifetime() >= lifetime) continue;
            lifetime = aCred.getLifetime();
        }
        return lifetime;
    }

    public int getRemainingInitLifetime(Oid mech) throws GSSException {
        GSSCredSpi aCred = this.getMechCred(mech, true);
        return aCred.getInitLifetime();
    }

    public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
        GSSCredSpi aCred = this.getMechCred(mech, true);
        return aCred.getAcceptLifetime();
    }

    public int getUsage() throws GSSException {
        boolean init = false;
        boolean accept = false;
        if (this.m_mechCreds.size() < 0) {
            throw new GSSException(13);
        }
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            GSSCredSpi aCred = (GSSCredSpi)e.nextElement();
            if (aCred.getUsage() == 0) {
                return 0;
            }
            if (aCred.getUsage() == 1) {
                init = true;
            } else if (aCred.getUsage() == 2) {
                accept = true;
            }
            if (!init || !accept) continue;
            return 0;
        }
        if (init) {
            return 1;
        }
        return 2;
    }

    public int getUsage(Oid mechOID) throws GSSException {
        GSSCredSpi aCred = this.getMechCred(mechOID, true);
        return aCred.getUsage();
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oids = new Oid[this.m_mechCreds.size()];
        int i = 0;
        if (this.m_mechCreds.size() < 1) {
            throw new GSSException(13);
        }
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            oids[i++] = ((GSSCredSpi)e.nextElement()).getMechanism();
        }
        return oids;
    }

    public synchronized void add(GSSName aName, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        if (mech == null) {
            mech = GSSManager.getDefaultMech();
        }
        if (this.getMechCred(mech, false) != null) {
            throw new GSSException(17);
        }
        GSSCredSpi newCred = GSSManager.getCredInstance(mech);
        newCred.init(aName.canonicalizeInPlace(mech), initLifetime, acceptLifetime, usage);
        this.m_mechCreds.addElement(newCred);
    }

    public boolean equals(Object another) {
        if (!(another instanceof GSSCredential)) {
            return false;
        }
        GSSCredential aCred = (GSSCredential)another;
        if (aCred.m_mechCreds.size() != this.m_mechCreds.size()) {
            return false;
        }
        try {
            Enumeration e = this.m_mechCreds.elements();
            while (e.hasMoreElements()) {
                GSSCredSpi intCred = (GSSCredSpi)e.nextElement();
                GSSCredSpi anotherIntCred = aCred.getMechCred(intCred.getMechanism(), false);
                if (anotherIntCred == null) {
                    return false;
                }
                if (intCred.equals(anotherIntCred)) continue;
                return false;
            }
        }
        catch (GSSException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(150);
        sb.append(super.toString());
        sb.append("\nOver mechs:\t");
        try {
            Oid[] mechs = this.getMechs();
            for (int i = 0; i < mechs.length; ++i) {
                sb.append(mechs[i].toString() + " ");
            }
            sb.append("\nFor principal:\t" + this.getGSSName().toString());
            sb.append("\nUsage:\t" + this.getUsage());
            if (this.getUsage() == 2) {
                sb.append(" (ACCEPT_ONLY)");
            } else if (this.getUsage() == 1) {
                sb.append(" (INITIATE_ONLY)");
            } else {
                sb.append(" (INITIATE and ACCEPT)");
            }
            sb.append("\nRemaining Lifetime:\t" + this.getRemainingLifetime());
        }
        catch (GSSException e) {
            sb.append("\n***ERROR getting info:\t" + e.toString());
        }
        return sb.toString();
    }

    GSSCredSpi getMechCred(Oid mechOid, boolean throwExcep) throws GSSException {
        Enumeration e = this.m_mechCreds.elements();
        while (e.hasMoreElements()) {
            GSSCredSpi aCred = (GSSCredSpi)e.nextElement();
            if (!aCred.getMechanism().equals(mechOid)) continue;
            return aCred;
        }
        if (throwExcep) {
            throw new GSSException(2);
        }
        return null;
    }
}

