/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import java.net.InetAddress;

public class ChannelBinding {
    private InetAddress m_initiator;
    private InetAddress m_acceptor;
    private byte[] m_appData;

    public ChannelBinding(InetAddress initAddr, InetAddress acceptAddr, byte[] appData) {
        this.m_initiator = initAddr;
        this.m_acceptor = acceptAddr;
        if (appData != null) {
            this.m_appData = new byte[appData.length];
            System.arraycopy(appData, 0, this.m_appData, 0, this.m_appData.length);
        }
    }

    public ChannelBinding(byte[] appData) {
        this.m_initiator = null;
        this.m_acceptor = null;
        this.m_appData = new byte[appData.length];
        System.arraycopy(appData, 0, this.m_appData, 0, this.m_appData.length);
    }

    public InetAddress getInitiatorAddress() {
        return this.m_initiator;
    }

    public InetAddress getAcceptorAddress() {
        return this.m_acceptor;
    }

    public byte[] getApplicationData() {
        return this.m_appData;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChannelBinding)) {
            return false;
        }
        ChannelBinding cb = (ChannelBinding)obj;
        if (this.getApplicationData() == null && cb.getApplicationData() != null || this.getApplicationData() != null && cb.getApplicationData() == null) {
            return false;
        }
        return this.m_initiator.equals(cb.getInitiatorAddress()) && this.m_acceptor.equals(cb.getAcceptorAddress()) && (this.getApplicationData() == null || this.m_appData.equals(cb.getApplicationData()));
    }
}

