/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.utils.URI;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolverId
extends ResourceResolverSpi {
    private static String implementationClassName = ResolverId.class.getName();
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static String getResolverName() {
        return implementationClassName;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerDocument();
        XMLUtils.circumventBug2650(doc);
        Element selectedElem = null;
        if (uriNodeValue.equals("")) {
            selectedElem = doc.getDocumentElement();
        } else {
            String id = uriNodeValue.substring(1);
            try {
                selectedElem = this.getElementById(doc, id);
            }
            catch (TransformerException e) {
                log.log(Level.SEVERE, "WSS0603.xpathapi.transformer.exception", e.getMessage());
                throw new ResourceResolverException("empty", (Exception)e, uri, BaseURI);
            }
        }
        if (selectedElem == null) {
            log.log(Level.SEVERE, "WSS0604.cannot.find.element");
            throw new ResourceResolverException("empty", uri, BaseURI);
        }
        Set resultSet = this.dereferenceSameDocumentURI(selectedElem);
        XMLSignatureInput result = new XMLSignatureInput(resultSet);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(BaseURI);
        }
        return result;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#");
    }

    private Element getElementById(Document doc, String id) throws TransformerException {
        NodeList assertions;
        int len;
        Element selement = doc.getElementById(id);
        if (selement != null) {
            return selement;
        }
        Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Element element = (Element)XPathAPI.selectSingleNode(doc, "//*[@wsu:Id='" + id + "']", nscontext);
        if (element == null) {
            NodeList elems = XPathAPI.selectNodeList(doc, "//*[@Id='" + id + "']", nscontext);
            for (int i = 0; i < elems.getLength(); ++i) {
                Element elem = (Element)elems.item(i);
                String namespace = elem.getNamespaceURI();
                if (!namespace.equals("http://www.w3.org/2000/09/xmldsig#") && !namespace.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                element = elem;
                break;
            }
        }
        if (element == null && (len = (assertions = doc.getElementsByTagName("Assertion")).getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                Element elem = (Element)assertions.item(i);
                String assertionId = elem.getAttribute("AssertionID");
                if (!id.equals(assertionId)) continue;
                element = elem;
                break;
            }
        }
        return element;
    }

    private Set dereferenceSameDocumentURI(Node node) {
        HashSet nodeSet = new HashSet();
        if (node != null) {
            this.nodeSetMinusCommentNodes(node, nodeSet, null);
        }
        return nodeSet;
    }

    private void nodeSetMinusCommentNodes(Node node, Set nodeSet, Node prevSibling) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        nodeSet.add(attrs.item(i));
                    }
                }
                nodeSet.add(node);
                Node pSibling = null;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                    pSibling = child;
                }
                break;
            }
            case 3: 
            case 4: {
                if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                    return;
                }
            }
            case 7: {
                nodeSet.add(node);
            }
        }
    }
}

