/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.WssSoapFaultException;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;

public class SOAPUtil {
    public static String getIdFromFragmentRef(String ref) {
        char start = ref.charAt(0);
        if (start == '#') {
            return ref.substring(1);
        }
        return ref;
    }

    public static X509Certificate getCertificateFromToken(BinarySecurityToken bst) throws XWSSecurityException {
        X509Certificate cert = null;
        byte[] data = bst.getTokenValue();
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            throw new XWSSecurityException("Unable to create X509Certificate from data");
        }
        return cert;
    }

    public static WssSoapFaultException newSOAPFaultException(String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(null, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }
}

