/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.DerivedKeyToken;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secconv.impl.bindings.DerivedKeyTokenType;
import com.sun.xml.ws.security.secconv.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.secext10.KeyIdentifierType;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DerivedKey
implements DerivedKeyToken,
SecurityHeaderElement,
SecurityElementWriter {
    private DerivedKeyTokenType derivedKey = null;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private String refId = "";

    public DerivedKey(DerivedKeyTokenType dkt, SOAPVersion soapVersion) {
        this.derivedKey = dkt;
        this.soapVersion = soapVersion;
    }

    public DerivedKey(DerivedKeyTokenType dkt, SOAPVersion soapVersion, String refId) {
        this.derivedKey = dkt;
        this.soapVersion = soapVersion;
        this.refId = refId;
    }

    public String getAlgorithm() {
        return this.derivedKey.getAlgorithm();
    }

    public BigInteger getGeneration() {
        return this.derivedKey.getGeneration();
    }

    public String getId() {
        return this.derivedKey.getId();
    }

    public String getLabel() {
        return this.derivedKey.getLabel();
    }

    public BigInteger getLength() {
        return this.derivedKey.getLength();
    }

    public byte[] getNonce() {
        return this.derivedKey.getNonce();
    }

    public BigInteger getOffset() {
        return this.derivedKey.getOffset();
    }

    public SecurityTokenReferenceType getSecurityTokenReference() {
        return this.derivedKey.getSecurityTokenReference();
    }

    public void setAlgorithm(String value) {
        this.derivedKey.setAlgorithm(value);
    }

    public void setGeneration(BigInteger value) {
        this.derivedKey.setGeneration(value);
    }

    public void setId(String value) {
        this.derivedKey.setId(value);
    }

    public void setLabel(String value) {
        this.derivedKey.setLabel(value);
    }

    public void setLength(BigInteger value) {
        this.derivedKey.setLength(value);
    }

    public void setNonce(byte[] value) {
        this.derivedKey.setNonce(value);
    }

    public void setOffset(BigInteger value) {
        this.derivedKey.setOffset(value);
    }

    public void setSecurityTokenReference(SecurityTokenReferenceType value) {
        this.derivedKey.setSecurityTokenReference(value);
    }

    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc";
    }

    public String getLocalPart() {
        return "DerivedKeyToken";
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream os) {
        try {
            JAXBElement<DerivedKeyTokenType> dkt = new ObjectFactory().createDerivedKeyToken(this.derivedKey);
            Marshaller writer = this.getMarshaller();
            writer.marshal(dkt, os);
        }
        catch (JAXBException ex) {
            throw new XWSSecurityRuntimeException(ex);
        }
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        JAXBElement<DerivedKeyTokenType> dkt = new ObjectFactory().createDerivedKeyToken(this.derivedKey);
        try {
            OutputStream os;
            Marshaller writer = this.getMarshaller();
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                writer.marshal(dkt, os);
                return;
            }
            writer.marshal(dkt, streamWriter);
        }
        catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    public boolean refersToSecHdrWithId(String id) {
        SecurityTokenReferenceType ref;
        List<Object> list;
        if (this.refId != null && this.refId.length() > 0 && this.refId.equals(id)) {
            return true;
        }
        if (this.getSecurityTokenReference() != null && (list = (ref = this.getSecurityTokenReference()).getAny()).size() > 0) {
            KeyIdentifierType ki;
            String valueType;
            JAXBElement je = (JAXBElement)list.get(0);
            Object obj = je.getValue();
            if (obj instanceof DirectReference) {
                StringBuffer sb = new StringBuffer();
                sb.append("#");
                sb.append(id);
                return ((DirectReference)obj).getURI().equals(sb.toString());
            }
            if (obj instanceof KeyIdentifierType && ((valueType = (ki = (KeyIdentifierType)obj).getValueType()).equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID") || valueType.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID")) && id.equals(ki.getValue())) {
                return true;
            }
        }
        return false;
    }

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            throw new XMLStreamException(jbe);
        }
    }
}

