/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.Signature;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.xml.crypto.KeySelector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAssertion
implements SecurityHeaderElement,
PolicyBuilder,
TokenValidator,
NamespaceContextInfo,
SecurityElementWriter {
    private String id = "";
    private String localName = "";
    private String namespaceURI = "";
    private Key key = null;
    private JAXBFilterProcessingContext jpc = null;
    private HashMap<String, String> samlHeaderNSContext = null;
    private StreamReaderBufferCreator creator = null;
    private Signature sig = null;
    private MutableXMLStreamBuffer buffer = null;
    private static final String KEYINFO_ELEMENT = "KeyInfo";

    public SAMLAssertion(XMLStreamReader reader, JAXBFilterProcessingContext jpc, StreamReaderBufferCreator creator, HashMap nsDecl) throws XWSSecurityException {
        this.jpc = jpc;
        this.creator = creator;
        this.id = reader.getAttributeValue(null, "AssertionID");
        if (this.id == null) {
            this.id = reader.getAttributeValue(null, "ID");
        }
        this.namespaceURI = reader.getNamespaceURI();
        this.localName = reader.getLocalName();
        this.samlHeaderNSContext = new HashMap();
        this.samlHeaderNSContext.putAll(nsDecl);
        if (reader.getNamespaceCount() > 0) {
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                this.samlHeaderNSContext.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
        }
        this.buffer = new MutableXMLStreamBuffer();
        StreamWriterBufferCreator bCreator = new StreamWriterBufferCreator(this.buffer);
        this.process(reader, (XMLStreamWriter)bCreator);
    }

    public SAMLAssertion() {
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.buffer.readAsXMLStreamReader();
    }

    @Override
    public WSSPolicy getPolicy() {
        return null;
    }

    @Override
    public void validate(ProcessingContext context) throws XWSSecurityException {
        try {
            context.getSecurityEnvironment().validateSAMLAssertion(context.getExtraneousProperties(), this.readHeader());
            context.getSecurityEnvironment().updateOtherPartySubject((Subject)context.getExtraneousProperties().get("javax.security.auth.Subject"), this.readHeader());
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while trying to validate SAMLAssertion", xe);
        }
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.samlHeaderNSContext;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.buffer.writeToXMLStreamWriter(streamWriter);
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        this.writeTo(streamWriter);
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    public boolean isHOK() {
        return this.sig != null;
    }

    public boolean validateSignature() throws XWSSecurityException {
        if (this.isHOK()) {
            return this.sig.validate();
        }
        return false;
    }

    public void processNoValidation(XMLStreamReader reader, XMLStreamWriter buffer) throws XWSSecurityException {
        try {
            StreamUtil.writeCurrentEvent(reader, buffer);
            while (reader.hasNext()) {
                reader.next();
                if (this._break(reader)) {
                    StreamUtil.writeCurrentEvent(reader, buffer);
                    reader.next();
                    break;
                }
                StreamUtil.writeCurrentEvent(reader, buffer);
            }
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    public void process(XMLStreamReader reader, XMLStreamWriter buffer) throws XWSSecurityException {
        try {
            StreamUtil.writeCurrentEvent(reader, buffer);
            while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 1: {
                        if (reader.getLocalName() != "Signature" || reader.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#") break;
                        this.sig = new Signature(this.jpc, this.samlHeaderNSContext, this.creator, false);
                        this.sig.process(reader, false);
                    }
                }
                if (this._break(reader)) {
                    StreamUtil.writeCurrentEvent(reader, buffer);
                    reader.next();
                    break;
                }
                StreamUtil.writeCurrentEvent(reader, buffer);
            }
        }
        catch (XMLStreamException xe) {
            throw new XWSSecurityException("Error occurred while reading SAMLAssertion", xe);
        }
    }

    public Key getKey() throws XWSSecurityException {
        if (this.key == null) {
            try {
                XMLStreamReader reader = this.readHeader();
                while (true) {
                    if (reader.getEventType() != 8) {
                        switch (reader.getEventType()) {
                            case 1: {
                                if (reader.getLocalName() != KEYINFO_ELEMENT || reader.getNamespaceURI() != "http://www.w3.org/2000/09/xmldsig#") break;
                                this.jpc.isSAMLEK(true);
                                KeyInfoProcessor kip = new KeyInfoProcessor(this.jpc, KeySelector.Purpose.VERIFY);
                                this.key = kip.getKey(reader);
                                this.jpc.isSAMLEK(false);
                                return this.key;
                            }
                        }
                        if (reader.hasNext()) {
                            reader.next();
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (XMLStreamException xe) {
                throw new XWSSecurityException("Error occurred while obtaining Key from SAMLAssertion", xe);
            }
        }
        return this.key;
    }

    private boolean _break(XMLStreamReader reader) {
        String uri;
        return reader.getEventType() == 2 && reader.getLocalName() == "Assertion" && ((uri = reader.getNamespaceURI()) == "urn:oasis:names:tc:SAML:2.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion");
    }
}

