/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.DerivedKeyToken;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedData;
import com.sun.xml.ws.security.opt.impl.incoming.EncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.KerberosBinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContextToken;
import com.sun.xml.ws.security.opt.impl.incoming.Signature;
import com.sun.xml.ws.security.opt.impl.incoming.SignatureConfirmation;
import com.sun.xml.ws.security.opt.impl.incoming.TimestampHeader;
import com.sun.xml.ws.security.opt.impl.incoming.UsernameTokenHeader;
import com.sun.xml.ws.security.opt.impl.incoming.X509BinarySecurityToken;
import com.sun.xml.wss.BasicSecurityProfile;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHeaderProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private static final int TIMESTAMP_ELEMENT = 1;
    private static final int USERNAMETOKEN_ELEMENT = 2;
    private static final int BINARYSECURITY_TOKEN_ELEMENT = 3;
    private static final int ENCRYPTED_DATA_ELEMENT = 4;
    private static final int ENCRYPTED_KEY_ELEMENT = 5;
    private static final int SIGNATURE_ELEMENT = 6;
    private static final int REFERENCE_LIST_ELEMENT = 7;
    private static final int DERIVED_KEY_ELEMENT = 8;
    private static final int SIGNATURE_CONFIRMATION_ELEMENT = 9;
    private static final int SECURITY_CONTEXT_TOKEN = 10;
    private static final int SAML_ASSERTION_ELEMEMENT = 11;
    private Map<String, String> currentParentNS = new HashMap<String, String>();
    private JAXBFilterProcessingContext context;
    private XMLInputFactory staxIF = null;
    private StreamReaderBufferCreator creator = null;
    private BasicSecurityProfile bspContext = null;

    public SecurityHeaderProcessor(JAXBFilterProcessingContext context, Map<String, String> namespaceList, XMLInputFactory xi, StreamReaderBufferCreator sbc) {
        this.context = context;
        this.currentParentNS = namespaceList;
        this.staxIF = xi;
        this.context = context;
        this.creator = sbc;
        this.bspContext = context.getBSPContext();
    }

    public SecurityHeaderElement createHeader(XMLStreamReader message) throws XWSSecurityException {
        int eventType = this.getSecurityElementType(message);
        try {
            while (eventType != -1) {
                switch (eventType) {
                    case 1: {
                        if (this.context.isBSP() && this.bspContext.isTimeStampFound()) {
                            BasicSecurityProfile.log_bsp_3203();
                        }
                        this.bspContext.setTimeStampFound(true);
                        TimestampHeader timestamp = new TimestampHeader(message, this.creator, (HashMap)this.currentParentNS, this.context);
                        timestamp.validate(this.context);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(timestamp);
                        this.context.getInferredSecurityPolicy().append(timestamp.getPolicy());
                        return timestamp;
                    }
                    case 3: {
                        String valueType = message.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "ValueType");
                        if (valueType == "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510") {
                            KerberosBinarySecurityToken kbst = new KerberosBinarySecurityToken(message, this.creator, (HashMap)this.currentParentNS, this.staxIF);
                            kbst.validate(this.context);
                            this.context.getSecurityContext().getProcessedSecurityHeaders().add(kbst);
                            this.context.getInferredSecurityPolicy().append(kbst.getPolicy());
                            if (this.context.isTrustMessage() && !this.context.isClient()) {
                                IssuedTokenContext ctx = null;
                                if (this.context.getTrustContext() == null) {
                                    ctx = new IssuedTokenContextImpl();
                                    ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                                    this.context.setTrustContext(ctx);
                                } else {
                                    ctx = this.context.getTrustContext();
                                    if (ctx.getAuthnContextClass() != null) {
                                        ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                                        this.context.setTrustContext(ctx);
                                    }
                                }
                            }
                            return kbst;
                        }
                        X509BinarySecurityToken bst = new X509BinarySecurityToken(message, this.creator, (HashMap)this.currentParentNS, this.staxIF);
                        bst.validate(this.context);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(bst);
                        this.context.getInferredSecurityPolicy().append(bst.getPolicy());
                        if (this.context.isTrustMessage() && !this.context.isClient()) {
                            IssuedTokenContext ctx = null;
                            if (this.context.getTrustContext() == null) {
                                ctx = new IssuedTokenContextImpl();
                                ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
                                this.context.setTrustContext(ctx);
                            } else {
                                ctx = this.context.getTrustContext();
                                if (ctx.getAuthnContextClass() != null) {
                                    ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
                                    this.context.setTrustContext(ctx);
                                }
                            }
                        }
                        return bst;
                    }
                    case 5: {
                        EncryptedKey ek = new EncryptedKey(message, this.context, (HashMap)this.currentParentNS);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(ek);
                        return ek;
                    }
                    case 4: {
                        EncryptedData ed = new EncryptedData(message, this.context, (HashMap)this.currentParentNS);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(ed);
                        return ed;
                    }
                    case 2: {
                        UsernameTokenHeader ut = new UsernameTokenHeader(message, this.creator, (HashMap)this.currentParentNS, this.staxIF);
                        ut.validate(this.context);
                        if (this.context.isTrustMessage() && !this.context.isClient()) {
                            IssuedTokenContext ctx = null;
                            if (this.context.getTrustContext() == null) {
                                ctx = new IssuedTokenContextImpl();
                                if (this.context.isSecure()) {
                                    ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                                } else {
                                    ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                                }
                                this.context.setTrustContext(ctx);
                            } else {
                                ctx = this.context.getTrustContext();
                                if (ctx.getAuthnContextClass() != null) {
                                    if (this.context.isSecure()) {
                                        ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                                    } else {
                                        ctx.setAuthnContextClass("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                                    }
                                    this.context.setTrustContext(ctx);
                                }
                            }
                        }
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(ut);
                        this.context.getInferredSecurityPolicy().append(ut.getPolicy());
                        return ut;
                    }
                    case 8: {
                        DerivedKeyToken dkt = new DerivedKeyToken(message, this.context, (HashMap)this.currentParentNS);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(dkt);
                        return dkt;
                    }
                    case 9: {
                        SignatureConfirmation signConfirm = new SignatureConfirmation(message, this.creator, (HashMap)this.currentParentNS, this.staxIF);
                        signConfirm.validate(this.context);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(signConfirm);
                        return signConfirm;
                    }
                    case 10: {
                        SecurityContextToken sct = new SecurityContextToken(message, this.context, (HashMap)this.currentParentNS);
                        this.context.getSecurityContext().getProcessedSecurityHeaders().add(sct);
                        return sct;
                    }
                    case 6: {
                        Signature sig = new Signature(this.context, this.currentParentNS, this.creator, true);
                        sig.process(message);
                        if (sig.getReferences().size() == 0) {
                            this.context.getSecurityContext().getProcessedSecurityHeaders().add(sig);
                        }
                        this.context.getInferredSecurityPolicy().append(sig.getPolicy());
                        return sig;
                    }
                    case 11: {
                        SAMLAssertion samlAssertion = new SAMLAssertion(message, this.context, null, (HashMap)this.currentParentNS);
                        return samlAssertion;
                    }
                }
                GenericSecuredHeader gsh = new GenericSecuredHeader(message, null, this.creator, (HashMap)this.currentParentNS, this.staxIF, this.context.getEncHeaderContent());
                eventType = this.getSecurityElementType(message);
            }
        }
        catch (XMLStreamException xe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1608_ERROR_SECURITY_HEADER());
            throw new XWSSecurityException(LogStringsMessages.WSS_1608_ERROR_SECURITY_HEADER(), xe);
        }
        catch (XMLStreamBufferException xbe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1608_ERROR_SECURITY_HEADER());
            throw new XWSSecurityException(LogStringsMessages.WSS_1608_ERROR_SECURITY_HEADER(), xbe);
        }
        return null;
    }

    private boolean isTimeStamp(XMLStreamReader reader) {
        return reader.getLocalName() == "Timestamp" && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    }

    private boolean isBST(XMLStreamReader reader) {
        return reader.getLocalName() == "BinarySecurityToken" && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    private boolean isSignature(XMLStreamReader reader) {
        return reader.getLocalName() == "Signature" && reader.getNamespaceURI() == "http://www.w3.org/2000/09/xmldsig#";
    }

    private boolean isEncryptedKey(XMLStreamReader reader) {
        return reader.getLocalName() == "EncryptedKey" && reader.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#";
    }

    private boolean isEncryptedData(XMLStreamReader reader) {
        return reader.getLocalName() == "EncryptedData" && reader.getNamespaceURI() == "http://www.w3.org/2001/04/xmlenc#";
    }

    private boolean isUsernameToken(XMLStreamReader reader) {
        return reader.getLocalName() == "UsernameToken" && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    private boolean isDerivedKey(XMLStreamReader reader) {
        return reader.getLocalName() == "DerivedKeyToken" && reader.getNamespaceURI() == "http://schemas.xmlsoap.org/ws/2005/02/sc";
    }

    private boolean isSignatureConfirmation(XMLStreamReader reader) {
        return reader.getLocalName() == "SignatureConfirmation" && reader.getNamespaceURI() == "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    }

    private boolean isSCT(XMLStreamReader reader) {
        return reader.getLocalName() == "SecurityContextToken" && reader.getNamespaceURI() == "http://schemas.xmlsoap.org/ws/2005/02/sc";
    }

    private boolean isSAML(XMLStreamReader message) {
        String uri;
        return message.getLocalName() == "Assertion" && ((uri = message.getNamespaceURI()) == "urn:oasis:names:tc:SAML:2.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion" || uri == "urn:oasis:names:tc:SAML:1.0:assertion");
    }

    private void moveToNextElement(XMLStreamReader reader) throws XMLStreamException {
        reader.next();
        while (reader.getEventType() != 1) {
            reader.next();
        }
    }

    public int getSecurityElementType(XMLStreamReader reader) {
        if (this.isTimeStamp(reader)) {
            return 1;
        }
        if (this.isBST(reader)) {
            return 3;
        }
        if (this.isSignature(reader)) {
            return 6;
        }
        if (this.isEncryptedKey(reader)) {
            return 5;
        }
        if (this.isEncryptedData(reader)) {
            return 4;
        }
        if (this.isUsernameToken(reader)) {
            return 2;
        }
        if (this.isSignatureConfirmation(reader)) {
            return 9;
        }
        if (this.isDerivedKey(reader)) {
            return 8;
        }
        if (this.isSCT(reader)) {
            return 10;
        }
        if (this.isSAML(reader)) {
            return 11;
        }
        return -1;
    }
}

