/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jwsdp.dev.java.net/CDDLv1.0.html
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
/*
 * $Id: SubjectConfirmation.java,v 1.6 2007/01/08 16:05:58 shyam_rao Exp $
 */

/*
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.xml.wss.saml.assertion.saml11.jaxb10;

import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.bind.util.ListImpl;

import com.sun.xml.wss.logging.LogDomainConstants;
import com.sun.xml.wss.saml.internal.saml11.jaxb10.KeyInfoType;
import com.sun.xml.wss.saml.internal.saml11.jaxb10.impl.SubjectConfirmationDataImpl;
import com.sun.xml.wss.saml.internal.saml11.jaxb10.impl.SubjectConfirmationTypeImpl;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import java.util.logging.Logger;


import java.security.PublicKey;

import javax.xml.bind.JAXBContext;

/**
 * The <code>SubjectConfirmation</code> element specifies a subject by specifying data that
 * authenticates the subject.
 */
public class SubjectConfirmation extends com.sun.xml.wss.saml.internal.saml11.jaxb10.impl.SubjectConfirmationImpl
        implements com.sun.xml.wss.saml.SubjectConfirmation {
    
    protected PublicKey keyInfoKeyValue = null;
    
    protected static final Logger log = Logger.getLogger(
            LogDomainConstants.WSS_API_DOMAIN,
            LogDomainConstants.WSS_API_DOMAIN_BUNDLE);
    
      
    public SubjectConfirmation(){
        
    }
    
    public void setConfirmationMethod(List confirmationMethod) {
        _ConfirmationMethod = new ListImpl(confirmationMethod);
    }
    
    /**
     * From scratch constructor for a single confirmation method.
     *
     * @param confirmationMethod A URI (String) that identifies a protocol used
     *        to authenticate a <code>Subject</code>. Please refer to
     *        <code>draft-sstc-core-25</code> Section 7 for a list of URIs
     *        identifying common authentication protocols.
     * @exception SAMLException if the input data is null.
     */
    public SubjectConfirmation(java.lang.String confirmationMethod) {
        
        List cm = new LinkedList();
        cm.add(confirmationMethod);
        setConfirmationMethod(cm);
    }
    
    /**
     * Constructs a subject confirmation element from an existing
     * XML block.
     *
     * @param subjectConfirmationElement a DOM Element representing the
     *        <code>SubjectConfirmation</code> object.
     * @throws SAMLException
     */
    public static SubjectConfirmationTypeImpl fromElement(org.w3c.dom.Element element)
    throws SAMLException {
        try {
            JAXBContext jc =
                    SAMLJAXBUtil.getJAXBContext();
            javax.xml.bind.Unmarshaller u = jc.createUnmarshaller();
            return (SubjectConfirmationTypeImpl)u.unmarshal(element);
        } catch ( Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }
    
    /**
     * Constructs an <code>SubjectConfirmation</code> instance.
     *
     * @param confirmationMethods A set of <code>confirmationMethods</code>
     *        each of which is a URI (String) that identifies a protocol
     *        used to authenticate a <code>Subject</code>. Please refer to
     *        <code>draft-sstc-core-25</code> Section 7 for
     *        a list of URIs identifying common authentication protocols.
     * @param subjectConfirmationData Additional authentication information to
     *        be used by a specific authentication protocol. Can be passed as
     *        null if there is no <code>subjectConfirmationData</code> for the
     *        <code>SubjectConfirmation</code> object.
     * @param keyInfo An XML signature element that specifies a cryptographic
     *        key held by the <code>Subject</code>.
     * @exception SAMLException if the input data is invalid or
     *            <code>confirmationMethods</code> is empty.
     */
    public SubjectConfirmation(
            List confirmationMethods, Element subjectConfirmationData,
            Element keyInfo) throws SAMLException {
        
        JAXBContext jc = null;
        javax.xml.bind.Unmarshaller u = null;
        
        //Unmarshal to JAXB KeyInfo Object and set it
        try {
            jc = SAMLJAXBUtil.getJAXBContext();
            u = jc.createUnmarshaller();
        } catch ( Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
        
        try {
            if ( keyInfo != null) {
                setKeyInfo((KeyInfoType)u.unmarshal(keyInfo));
            }
            
            if ( subjectConfirmationData != null) {
                setSubjectConfirmationData((SubjectConfirmationDataImpl)u.unmarshal(subjectConfirmationData));
            }
        } catch (Exception ex) {
            // log here
            throw new SAMLException(ex);
        }
        setConfirmationMethod(confirmationMethods);
    }
}
