/*
 * RealmAuthenticator.java
 *
 * Created on November 11, 2006, 2:11 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.wss;

import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultRealmAuthenticationAdapter;
import com.sun.xml.wss.impl.misc.ReflectionUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.xml.soap.SOAPException;

/**
 *
 * @author kumar jayanti
 */
public abstract class RealmAuthenticationAdapter {
    
    public static final String UsernameAuthenticator = "com.sun.xml.xwss.RealmAuthenticator";
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    // Prefixing with META-INF/ instead of /META-INF/. /META-INF/ is working fine
    // when loading from a JAR file but not when loading from a plain directory.
    private static final String JAR_PREFIX = "META-INF/";
  
    
    /** Creates a new instance of RealmAuthenticator */
    protected RealmAuthenticationAdapter() {
    }
    
    public abstract boolean authenticate(Subject callerSubject, String username, String password) throws XWSSecurityException;
    
    public static RealmAuthenticationAdapter newInstance(Object context) {
        RealmAuthenticationAdapter adapter = null;
        if (context == null) {
            // first try if it is an EJB jar
            URL url = SecurityUtil.loadFromClasspath("META-INF/services/" + UsernameAuthenticator);
            if (url != null) {
                adapter = loadReamlAuthenticator(url);
                if (adapter != null) {
                    return adapter;
                }
            }
            return new DefaultRealmAuthenticationAdapter();
            
        } else  {
            URL url = SecurityUtil.loadFromContext("/META-INF/services/" + UsernameAuthenticator, context); 
            return loadReamlAuthenticator(url);
        }
    }

    
    private static Object newInstance(String className,
            ClassLoader classLoader)
            throws SOAPException {
        try {
            Class spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                spiClass = classLoader.loadClass(className);
            }
            return spiClass.newInstance();
        } catch (ClassNotFoundException x) {
            throw new XWSSecurityRuntimeException(
                    "The following RealmAuthenticator: " + className + " specified in META-INF/services of the application archive was not found", x);
        } catch (Exception x) {
            throw new XWSSecurityRuntimeException(
                    "The following RealmAuthenticator: " + className + " specified in META-INF/services of the application archive could not be instantiated", x);
        }
    }
    

    private static RealmAuthenticationAdapter loadReamlAuthenticator(URL url) {
        InputStream is = null;
        if (url == null) {
            return null;
        }
        try {
            is = url.openStream();
            if(is!=null) {
                try {
                    BufferedReader rd =
                            new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null &&
                            ! "".equals(factoryClassName)) {
                        Object obj = newInstance(factoryClassName, Thread.currentThread().getContextClassLoader());
                        if (!(obj instanceof RealmAuthenticationAdapter)) {
                            throw new Exception("Class :" + factoryClassName + " is not a valid RealmAuthenticationProvider");
                        }
                        return (RealmAuthenticationAdapter)obj;
                    }
                } catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
            }
        } catch (IOException e) {
            return null;
        } 
        return null;
    }

}
