/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.util;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.staxex.NamespaceContextEx;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */
public class NamespaceAndPrefixMapper {
    
    public static final String NS_PREFIX_MAPPER = "NS_And_Prefix_Mapper";
    
    NamespaceContextEx ns = null;
    List<String> incList = null;
    
    /** Creates a new instance of NamespaceAndPrefixMapper */
    public NamespaceAndPrefixMapper(NamespaceContextEx ns, boolean disableIncPrefix) {
        this.ns = ns;
        incList = new ArrayList<String>();
        if(!disableIncPrefix){
            incList.add("wsse"); 
            incList.add("S");
        }
    }
    
    public NamespaceAndPrefixMapper(NamespaceContextEx ns, List<String> incList){
        this.ns = ns;
        this.incList = incList;
    }
    
    public void setNamespaceContext(NamespaceContextEx ns){
        this.ns = ns;
    }
    
    public NamespaceContextEx getNamespaceContext(){
        return ns;
    }
    
    public void addToInclusivePrefixList(String s){
        if(incList == null)
            incList = new ArrayList<String>();
        incList.add(s);
    }
    
    public void removeFromInclusivePrefixList(String s){
        if(incList == null)
            return;
        incList.remove(s);
    }
    
    public List<String> getInlusivePrefixList(){
        return incList;
    }
}