/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.api.reference.DirectReference;
import com.sun.xml.ws.security.DerivedKeyToken;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import java.security.Key;
import java.util.logging.Level;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;

import javax.xml.bind.JAXBElement;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class DerivedKeyTokenBuilder extends TokenBuilder {
    
    private DerivedTokenKeyBinding dtk = null;
    /** Creates a new instance of DerivedKeyTokenBuilder */
    public DerivedKeyTokenBuilder(JAXBFilterProcessingContext context,DerivedTokenKeyBinding dtk) {
        super(context);
        this.dtk = dtk;
    }
    
    public BuilderResult process() throws XWSSecurityException {
        
        String algorithm = null;
        WSSPolicy originalKeyBinding = dtk.getOriginalKeyBinding();
        AlgorithmSuite algSuite = context.getAlgorithmSuite();
        BuilderResult dktResult = new BuilderResult();
                
        if(algSuite != null){
            algorithm = algSuite.getEncryptionAlgorithm();
            if(logger.isLoggable(Level.FINEST)){
                logger.log(Level.FINEST, "Algorithm used for Derived Keys: "+algorithm);
            }
        } else{
            throw new XWSSecurityException("Internal Error: Algorithm Suite is not set in context");
        }
        //The offset and length to be used for DKT
        long offset = 0; // Default 0
        long length = SecurityUtil.getLengthFromAlgorithm(algorithm);
        
        WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
        if(length == 32 && PolicyTypeUtil.signaturePolicy(policy)){
            length = 24;
        }
        String dpTokenID = "";
        byte[] secret =null;
        BuilderResult result = null;
        // findbugs :correctness error, will lead to NPE if result was accessed later.
        /*if (PolicyTypeUtil.x509CertificateBinding(originalKeyBinding)) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1805_DERIVEDKEYS_WITH_ASYMMETRICBINDING_UNSUPPORTED());
            //throw new XWSSecurityException("Asymmetric Binding with DerivedKeys under X509Token Policy Not Yet Supported");
        } else*/ 
        if ( PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) {
            //SymmetricKeyBinding skb = (SymmetricKeyBinding)originalKeyBinding;
            SymmetricKeyBinding skb = null;
            if ( context.getSymmetricKeyBinding() != null) {
                skb = context.getSymmetricKeyBinding();
                context.setSymmetricKeyBinding(null);
            } else{
                throw new XWSSecurityException("Internal Error: SymmetricBinding not set on context");
            }
            String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(context);
            
            String keyAlgo = skb.getKeyAlgorithm();
            if(keyAlgo == null || "".equals(keyAlgo)){
                if(context.getAlgorithmSuite() != null)
                    keyAlgo = context.getAlgorithmSuite().getAsymmetricKeyAlgorithm();
            }
            SymmetricTokenBuilder stb = new SymmetricTokenBuilder(skb,context,dataEncAlgo,keyAlgo);
            result = stb.process();
            Key originalKey = result.getDataProtectionKey();
            secret = originalKey.getEncoded();
            if(logger.isLoggable(Level.FINEST)){
                logger.log(Level.FINEST, "SymmetricBinding under Derived Keys");
                logger.log(Level.FINEST, "DataEncryption Algorithm:"+dataEncAlgo);
                logger.log(Level.FINEST, "Key Algorithm:"+keyAlgo);
            }
        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
            SecureConversationTokenKeyBinding skb = (SecureConversationTokenKeyBinding)originalKeyBinding;
            SCTBuilder builder = new SCTBuilder(context, (SecureConversationTokenKeyBinding) originalKeyBinding);
            result = builder.process();
            IssuedTokenContext ictx = context.getSecureConversationContext();
            com.sun.xml.ws.security.SecurityContextToken sct =(com.sun.xml.ws.security.SecurityContextToken)ictx.getSecurityToken();            
            if(sct.getInstance() != null){
                if(context.isExpired()){
                    secret = ictx.getProofKey();
                }else{
                    SecurityContextTokenInfo sctInstanceInfo = ictx.getSecurityContextTokenInfo();
                    //secret = context.getSecureConversationContext().getProofKey();
                    secret = sctInstanceInfo.getInstanceSecret(sct.getInstance());
                }
            }else{
                secret = ictx.getProofKey();
            }
            if(logger.isLoggable(Level.FINEST)){
                logger.log(Level.FINEST, "SecureConversation token binding under Derived Keys");
            }
        }else if( PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) {
            IssuedTokenBuilder itb = new IssuedTokenBuilder(context,(IssuedTokenKeyBinding)originalKeyBinding);
            result = itb.process();
            Key originalKey = result.getDataProtectionKey();
            //ignore derived key when issuedtoken is public key
            if (context.getTrustContext().getProofKey() == null) {
                dktResult.setDataProtectionKey(originalKey);
                //keyinfo
                dktResult.setKeyInfo(result.getKeyInfo());
                return dktResult;
            }
            
            secret = originalKey.getEncoded();
            dpTokenID = result.getDPTokenId();
            
            if(logger.isLoggable(Level.FINEST)){
                logger.log(Level.FINEST, "Issued Token Binding token binding under Derived Keys");
            }
        } else{
            if(originalKeyBinding != null){
                throw new XWSSecurityException("Unsupported Key Binding:" + originalKeyBinding);
            } else{
                throw new XWSSecurityException("Internal Error: Null original key binding");
            }
        }
        
        DerivedKeyToken dkt = new DerivedKeyTokenImpl(offset, length, secret);
        Key dataKey = null;
        try{
            String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(algorithm);
            dataKey = dkt.generateSymmetricKey(jceAlgo);
        } catch(Exception e){
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1806_ERROR_GENERATING_SYMMETRIC_KEY());
            throw new XWSSecurityException(e);
        }
        SecurityTokenReferenceType str = null;
        Object strObj = result.getKeyInfo().getContent().get(0);
        if(strObj instanceof JAXBElement){
            str = (SecurityTokenReferenceType) ((JAXBElement)strObj).getValue();
        }else{
            str = (SecurityTokenReferenceType)strObj;
        }
        
        DerivedKey dk = null;
        if(dpTokenID.length() == 0){
            dk = elementFactory.createDerivedKey(dtk.getUUID(),algorithm,dkt.getNonce(),dkt.getOffset(),dkt.getLength(),dkt.getLabel(),str, context.getSecurityPolicyVersion());
        }else{
            dk = elementFactory.createDerivedKey(dtk.getUUID(),algorithm,dkt.getNonce(),dkt.getOffset(),dkt.getLength(),dkt.getLabel(),str,dpTokenID, context.getSecurityPolicyVersion());
        }
        DirectReference dr = elementFactory.createDirectReference();
        dr.setURI("#"+dk.getId());
        SecurityTokenReference str2 = buildSTR(context.generateID(),dr);
        context.getSecurityHeader().add(dk);
        //Construct the STR for Encryption or Signature
        buildKeyInfo(str2);
        dktResult.setKeyInfo(super.keyInfo);
        dktResult.setDataProtectionKey(dataKey);
        return dktResult;
    }
}
