/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.wss.impl.MessageConstants;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamReader;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */

public class UsernameTokenProcessor implements StreamFilter{
    
    String username = null;
    String password = null;
    String passwordDigest = null;
    String passwordType = null;
    String nonce = null;
    String created = null;
    String currentElement = "";
    
    private static String USERNAME = "Username".intern();
    private static String PASSWORD = "Password".intern();
    private static String NONCE = "Nonce".intern();
    private static String CREATED = "Created".intern();
    
    /** Creates a new instance of UsernameTokenProcessor */
    public UsernameTokenProcessor() {
    }
    
    public boolean accept(XMLStreamReader reader) {
        
        if(reader.getEventType() == XMLStreamReader.START_ELEMENT){
            
            if("Username".equals(reader.getLocalName())){
                currentElement = USERNAME;
            } else if("Password".equals(reader.getLocalName())){
                currentElement = PASSWORD;
                passwordType = reader.getAttributeValue(null, "Type");
            } else if("Nonce".equals(reader.getLocalName())){
                currentElement = NONCE;
            } else if("Created".equals(reader.getLocalName())){
                currentElement = CREATED;
            }
        }
        
        if(reader.getEventType() == XMLStreamReader.CHARACTERS){
            if(currentElement == USERNAME){
                username = reader.getText();
                currentElement = "";
            } else if(currentElement == PASSWORD){
                if(MessageConstants.PASSWORD_DIGEST_NS.equals(passwordType)){
                    passwordDigest = reader.getText();
                } else{
                    password = reader.getText();
                }
                currentElement = "";
            } else if(currentElement == NONCE){
                nonce = reader.getText();
                currentElement = "";
            } else if(currentElement == CREATED){
                created = reader.getText();
                currentElement = "";
            }
        }
        return true;
    }
    
    public String getUsername(){
        return username;
    }
    
    public String getPassword(){
        return password;        
    }
    
    public String getPasswordDigest(){
        return passwordDigest;
    }
    
    public String getPasswordType(){
        return passwordType;
    }
    
    public String getNonce(){
        return nonce;
    }
    
    public String getCreated(){
        return created;
    }
}

