/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.policy.MLSPolicy;

import java.util.ArrayList;
import java.util.HashMap;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SecurityContext {
    
    private ArrayList processedSecurityHeaders = new ArrayList(2);
    private ArrayList bufferedSecurityHeaders = null;
    private HeaderList nonSecurityHeaders = null;
    private HashMap<String,String> shND = null;
    private HashMap<String,String> envND = null;
    private AttachmentSet attachments = null; 
    
    private MLSPolicy inferredKB = null;
    
    private ProcessingContext pc = null;
    
    private boolean isSAMLKB = false;
    
    /** Creates a new instance of SecurityContext */
    public SecurityContext() {
      
    }
    
    public void setAttachmentSet(AttachmentSet attachments){
        this.attachments = attachments;
    }
    
    public AttachmentSet getAttachmentSet(){
        return attachments;
    }
    
    public MLSPolicy getInferredKB(){
        return inferredKB;
    }
    
    public void setInferredKB(MLSPolicy inferredKB){
        this.inferredKB = inferredKB;
    }
    
    public void setProcessedSecurityHeaders(ArrayList headers){
        this.processedSecurityHeaders =  headers;
    }
    
    public ArrayList getProcessedSecurityHeaders(){
        return processedSecurityHeaders;
    }
    
    public void setBufferedSecurityHeaders(ArrayList headers){
        this.bufferedSecurityHeaders =  headers;
    }
    
    public ArrayList getBufferedSecurityHeaders(){
        return bufferedSecurityHeaders;
    }
    
    public HeaderList getNonSecurityHeaders(){
        return nonSecurityHeaders;
    }
    
    public void setNonSecurityHeaders(HeaderList list){
        this.nonSecurityHeaders = list;
    }
    
    public void setSecurityHdrNSDecls(HashMap<String,String> nsDecls){
        this.shND = nsDecls;
    }
    
    public HashMap<String,String> getSecurityHdrNSDecls(){
        return this.shND;
    }
    
    public void setSOAPEnvelopeNSDecls(HashMap<String,String> nsDecls){
        this.envND = nsDecls;
    }
    
    public HashMap<String,String> getSOAPEnvelopeNSDecls(){
        return envND;
    }
    
    
    
    public ProcessingContext getProcessingContext() {
        return pc;
    }
    
    public void setProcessingContext(ProcessingContext pc){
        this.pc = pc;
    }
      
    public void setIsSAMLKeyBinding(boolean flag) {
        this.isSAMLKB = flag;
    }
    
    public boolean getIsSAMLKeyBinding() {
       return this.isSAMLKB;
    }
}
