/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.processor.ReferenceListProcessor;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/**
 *
 * @author Ashutosh.Shahi@sun.com
 */
public class ReferenceListHeader implements SecurityHeaderElement, SecurityElementWriter, PolicyBuilder{

    //private static String DATA_REFERENCE = "DataReference".intern();
    private static final int DATA_REFERENCE_ELEMENT = 1;
    
    private String id = "";
    private String namespaceURI = "";
    private String localName = "";
    private JAXBFilterProcessingContext pc = null;
    private ArrayList<String> referenceList = null;
    private ArrayList<String> pendingRefList = null;
    
    private EncryptionPolicy encPolicy = null;
    
    /** Creates a new instance of ReferenceListHeader */
    public ReferenceListHeader(XMLStreamReader reader,JAXBFilterProcessingContext pc) throws XMLStreamException{
        this.pc = pc;
        encPolicy = new EncryptionPolicy();
        encPolicy.setFeatureBinding(new EncryptionPolicy.FeatureBinding());
        process(reader);
    }

    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceURI() {
        return namespaceURI;
    }

    public String getLocalPart() {
        return localName;
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }
   
    public List<String> getReferenceList() {
        return referenceList;
    }
    
    public List<String> getPendingReferenceList() {
        return pendingRefList;
    }

    private void process(XMLStreamReader reader) throws XMLStreamException{
        id = reader.getAttributeValue(null,"Id");
        namespaceURI = reader.getNamespaceURI();
        localName = reader.getLocalName();
        
        ReferenceListProcessor rlp = new ReferenceListProcessor(encPolicy);
        rlp.process(reader);
        referenceList = rlp.getReferences();
        pendingRefList = (ArrayList<String>) referenceList.clone();
    }

    public void writeTo(javax.xml.stream.XMLStreamWriter streamWriter, HashMap props) throws javax.xml.stream.XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public WSSPolicy getPolicy() {
        return encPolicy;
    }
    
}
