/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.crypto;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamFilter;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;
/**
 *
 * @author K.Venugopal@sun.com
 */
public class StreamHeaderData implements StreamWriterData{
    private NamespaceContextEx nsContext;
    private boolean contentOnly;
    private Header data;
    /** Creates a new instance of HeaderData */
    public StreamHeaderData(Header header,boolean contentOnly,NamespaceContextEx ns) {
        this.data = header;
        nsContext = ns;
        this.contentOnly = contentOnly;
    }
    
    public NamespaceContextEx getNamespaceContext() {
        return nsContext;
    }
    
    public void write(javax.xml.stream.XMLStreamWriter writer) throws javax.xml.stream.XMLStreamException {
        if(contentOnly){
            XMLStreamWriter fw;            
            fw = new XMLStreamFilter(writer, (com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx)nsContext);            
            data.writeTo(fw);
        }else{
            data.writeTo(writer);
        }
    }    
}
