/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.impl.crypto;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.ws.security.opt.crypto.JAXBData;
import com.sun.xml.wss.logging.LogDomainConstants;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class JAXBDataImpl implements JAXBData {
    
    private static final Logger logger = Logger.getLogger(LogDomainConstants.IMPL_OPT_DOMAIN,
            LogDomainConstants.IMPL_OPT_DOMAIN_BUNDLE);
    
    private JAXBElement jb;
    private JAXBContext jc;
    private Header header = null;
    private SecurityElement securityElement = null;
    private boolean contentOnly = false;
    private NamespaceContextEx nsContext = null;
    
    /** Creates a new instance of JAXBDataImpl */
    
    public JAXBDataImpl(JAXBElement jb,JAXBContext jc,boolean contentOnly, NamespaceContextEx nsContext) {
        this.jb = jb;
        this.jc = jc;
        this.contentOnly = contentOnly;
        this.nsContext = nsContext;
    }
    
    public JAXBDataImpl(Header header,boolean contentOnly, NamespaceContextEx nsContext) {
        this.header = header;
        this.contentOnly = contentOnly;
        this.nsContext = nsContext;
    }
    
    public JAXBDataImpl(SecurityElement se, NamespaceContextEx nsContext,boolean contentOnly) {
        this.securityElement = se;
        this.contentOnly = contentOnly;
        this.nsContext = nsContext;
    }
    
    /** Creates a new instance of JAXBDataImpl */
    public JAXBDataImpl(JAXBElement jb,JAXBContext jc, NamespaceContextEx nsContext) {
        this.jb = jb;
        this.jc = jc;
        this.nsContext = nsContext;
    }
    
    
    public JAXBDataImpl(Header header) {
        this.header = header;
    }
    
    public JAXBDataImpl(SecurityElement se) {
        this.securityElement = se;
    }
    
    public JAXBElement getJAXBElement(){
        return jb;
    }
    
    public void writeTo(XMLStreamWriter writer)throws XWSSecurityException{
        if(securityElement != null){
            try {
                ((SecurityElementWriter)securityElement).writeTo(writer);
            } catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1609_ERROR_SERIALIZING_ELEMENT(securityElement.getLocalPart()));
                throw new XWSSecurityException(LogStringsMessages.WSS_1609_ERROR_SERIALIZING_ELEMENT(securityElement.getLocalPart()),ex);
            }
            return;
        }
        
        if(header != null){
            try {
                header.writeTo(writer);
            } catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1609_ERROR_SERIALIZING_ELEMENT(header.getLocalPart()));
                throw new XWSSecurityException(LogStringsMessages.WSS_1609_ERROR_SERIALIZING_ELEMENT(header.getLocalPart()),ex);
            }
            return;
        }
        
        Marshaller mh;
        try {
            mh = jc.createMarshaller();
            mh.marshal(jb,writer);
        }catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1610_ERROR_MARSHALLING_JBOBJECT(jb.getName()));
            throw new XWSSecurityException(
                    LogStringsMessages.WSS_1610_ERROR_MARSHALLING_JBOBJECT(jb.getName()),ex);
        }
    }
    
    public void writeTo(OutputStream os) throws XWSSecurityException {        
        Marshaller mh;        
        try {            
            mh = jc.createMarshaller();            
            mh.setProperty("com.sun.xml.bind.c14n",true);            
            mh.marshal(jb,os);            
        } catch (javax.xml.bind.JAXBException ex) {            
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1610_ERROR_MARSHALLING_JBOBJECT(jb.getName()));            
            throw new XWSSecurityException(LogStringsMessages.WSS_1610_ERROR_MARSHALLING_JBOBJECT(jb.getName()),ex);            
        }        
    }       
    
    public NamespaceContextEx getNamespaceContext() {        
        return nsContext;        
    }   
    
    public SecurityElement getSecurityElement() {        
        return securityElement;        
    }    
}