/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.api.tokens;

/**
 * Representation of UsernameToken SecurityHeaderElement
 * @author Ashutosh.Shahi@sun.com
 */
public interface UsernameToken {
    
    /**
     * 
     * @return the username value
     */
    String getUsernameValue();
    
    /**
     * sets the username value for this token
     * @param username username value
     */
    void setUsernameValue(final String username);
    
    /**
     * 
     * @return the password for this token
     */
    String getPasswordValue();
    
    /**
     * sets the password value for this token
     * @param passwd the password value
     */
    void setPasswordValue(final String passwd);
    
}
