/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.ws.security.opt.api.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
/**
 * 
 * Interface for processor of various token types like X509, SAML, SCT etc
 * @author K.Venugopal@sun.com
 */
public interface TokenBuilder {
    /**
     * Processes the token to obtain the keys etc
     * @return a <CODE>BuilderResult</CODE> with all token details set in it
     * @throws com.sun.xml.wss.XWSSecurityException exception if the various token information could not be obtained
     */
    BuilderResult process()throws XWSSecurityException;
}
